/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.element.tree;

import com.kms.katalon.composer.mobile.objectspy.constant.ImageConstants;
import com.kms.katalon.composer.mobile.objectspy.element.impl.CapturedMobileElement;
import com.kms.katalon.constants.GlobalStringConstants;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.ViewerCell;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;

public class MobileCapturedElementLabelProvider
extends CellLabelProvider {
    public void update(ViewerCell cell) {
        String name = GlobalStringConstants.EMPTY;
        if (cell.getElement() != null && cell.getElement() instanceof CapturedMobileElement) {
            name = ((CapturedMobileElement)cell.getElement()).getName();
        }
        this.setColor(cell);
        cell.setText(name);
        cell.setImage(this.getImage(cell.getElement()));
    }

    private void setColor(ViewerCell cell) {
        Object element = cell.getElement();
        if (element == null || !(element instanceof CapturedMobileElement)) {
            return;
        }
        CapturedMobileElement htmlElement = (CapturedMobileElement)element;
        if (htmlElement.isConflicted()) {
            cell.setForeground(Display.getCurrent().getSystemColor(3));
        }
    }

    private Image getImage(Object element) {
        if (!(element instanceof CapturedMobileElement)) {
            return null;
        }
        CapturedMobileElement htmlElement = (CapturedMobileElement)element;
        Image baseImage = ImageConstants.IMG_16_ACTIVE;
        Image overlayImage = htmlElement.isConflicted() ? ImageConstants.IMG_16_CONFLICT_ELEMENT_STATUS : ImageConstants.IMG_16_NEW_ELEMENT_STATUS;
        return this.combineTwoImages(baseImage, overlayImage);
    }

    private Image combineTwoImages(Image baseImage, Image overlayImage) {
        ImageDescriptor[] imageDescriptorArray = new ImageDescriptor[5];
        imageDescriptorArray[4] = ImageDescriptor.createFromImage((Image)baseImage);
        DecorationOverlayIcon decoratedImage = new DecorationOverlayIcon(overlayImage, imageDescriptorArray, new Point(baseImage.getBounds().width, baseImage.getBounds().height));
        return decoratedImage.createImage();
    }
}

