/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.handler;

import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.util.DialogUtil;
import com.kms.katalon.composer.mobile.objectspy.components.CustomRemoteAppComposite;
import com.kms.katalon.composer.mobile.objectspy.dialog.MobileObjectSpyDialog;
import com.kms.katalon.composer.mobile.util.MobileUtil;
import com.kms.katalon.configuration.core.interfaces.IDriverConnector;
import com.kms.katalon.configuration.core.interfaces.IRunConfiguration;
import com.kms.katalon.constants.GlobalMessageConstants;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.execution.collector.RunConfigurationCollector;
import com.kms.katalon.execution.configuration.contributor.CustomRunConfigurationContributor;
import com.kms.katalon.execution.core.exceptions.ExecutionException;
import com.kms.katalon.execution.webui.configuration.RemoteWebRunConfiguration;
import com.kms.katalon.execution.webui.driver.RemoteWebDriverConnector;
import jakarta.inject.Named;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.ui.model.application.ui.menu.MMenuItem;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class CustomCapabilitiesHandler {
    private ProjectEntity currentProject;
    private IRunConfiguration runConfiguration = null;
    private IDriverConnector driverConnector = null;

    @CanExecute
    public boolean canExecute(MMenuItem menuItem) {
        block6: {
            this.currentProject = ProjectController.getInstance().getCurrentProject();
            if (this.currentProject == null) {
                return false;
            }
            this.runConfiguration = this.getRunConfiguration(this.currentProject.getFolderLocation(), menuItem.getElementId());
            if (this.runConfiguration != null) break block6;
            return false;
        }
        try {
            Map driverConnectors = this.runConfiguration.getDriverConnectors();
            if (driverConnectors.size() > 0) {
                RemoteWebDriverConnector.RemoteWebDriverConnectorType connectorType;
                this.driverConnector = (IDriverConnector)driverConnectors.get("Remote");
                if (this.driverConnector != null && this.driverConnector instanceof RemoteWebDriverConnector && RemoteWebDriverConnector.RemoteWebDriverConnectorType.Appium.equals((Object)(connectorType = ((RemoteWebDriverConnector)this.driverConnector).getRemoteWebDriverConnectorType()))) {
                    return true;
                }
            }
        }
        catch (ExecutionException | IOException | InterruptedException e) {
            LoggerSingleton.logError((Throwable)e);
        }
        return false;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell activeShell) {
        MobileUtil.detectAppiumAndNodeJs((Shell)activeShell);
        this.openRecorderDialog(activeShell);
    }

    private IRunConfiguration getRunConfiguration(String projectDir, String menuId) throws IOException, InterruptedException, ExecutionException {
        CustomRunConfigurationContributor[] customRunConfigurationContributorArray = RunConfigurationCollector.getInstance().getAllCustomRunConfigurationContributors();
        int n = customRunConfigurationContributorArray.length;
        int n2 = 0;
        while (n2 < n) {
            CustomRunConfigurationContributor customRunConfigContributor = customRunConfigurationContributorArray[n2];
            String runConfigurationId = "com.kms.katalon.composer.mobile.objectspy.custom." + customRunConfigContributor.getId();
            if (StringUtils.equals((CharSequence)menuId, (CharSequence)runConfigurationId)) {
                return customRunConfigContributor.getRunConfiguration(projectDir);
            }
            ++n2;
        }
        return null;
    }

    private boolean openRecorderDialog(Shell activeShell) {
        try {
            Shell dialogShell = DialogUtil.createDialogShell((Shell)activeShell);
            RemoteWebRunConfiguration runConfiguration = new RemoteWebRunConfiguration(this.currentProject.getFolderLocation(), (RemoteWebDriverConnector)this.driverConnector);
            CustomRemoteAppComposite mobileAppComposide = new CustomRemoteAppComposite((IRunConfiguration)runConfiguration);
            MobileObjectSpyDialog objectSpyDialog = new MobileObjectSpyDialog(dialogShell, mobileAppComposide);
            return objectSpyDialog.open() != 0;
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            MessageDialog.openError((Shell)activeShell, (String)GlobalMessageConstants.ERROR, (String)e.getMessage());
            return false;
        }
    }
}

