/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.mobile.objectspy.util;

import com.kms.katalon.composer.mobile.objectspy.dialog.MobileDeviceDialog;
import com.kms.katalon.composer.mobile.objectspy.element.MobileElement;
import com.kms.katalon.composer.mobile.objectspy.element.TreeMobileElement;
import java.awt.geom.Point2D;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;

public class ElementSelectionHelper {
    public List<TreeMobileElement> findTopMostElementsByLocation(TreeMobileElement rootElement, final int x, final int y) {
        List<TreeMobileElement> potentialElements = this.findElementsByLocation(rootElement, x, y);
        potentialElements.sort(new Comparator<TreeMobileElement>(){

            @Override
            public int compare(TreeMobileElement element1, TreeMobileElement element2) {
                return ElementSelectionHelper.this.isHigherLayer(element1, element2, x, y) ? -1 : 1;
            }
        });
        return potentialElements;
    }

    public TreeMobileElement findTopMostElementByLocation(TreeMobileElement rootElement, int x, int y) {
        List<TreeMobileElement> potentialElements = this.findTopMostElementsByLocation(rootElement, x, y);
        return potentialElements.isEmpty() ? null : potentialElements.get(0);
    }

    public List<TreeMobileElement> findElementsByLocation(TreeMobileElement currentElement, int x, int y) {
        ArrayList<TreeMobileElement> childrenElements = new ArrayList<TreeMobileElement>();
        if (currentElement == null) {
            return childrenElements;
        }
        for (TreeMobileElement treeMobileElement : currentElement.getChildrenElement()) {
            childrenElements.addAll(this.findElementsByLocation(treeMobileElement, x, y));
        }
        if (!childrenElements.isEmpty()) {
            return childrenElements;
        }
        if (this.isPointInElementBounds(currentElement, x, y)) {
            return Arrays.asList(currentElement);
        }
        return Collections.emptyList();
    }

    private double findNearestDistance(TreeMobileElement element, int x, int y) {
        Rectangle elementBounds = this.getElementBounds(element);
        Point elementCenter = new Point(elementBounds.x + elementBounds.width / 2, elementBounds.y + elementBounds.height / 2);
        double distance = Point2D.distance(x, y, elementCenter.x, elementCenter.y);
        return distance;
    }

    private boolean isHigherLayer(TreeMobileElement element1, TreeMobileElement element2, int x, int y) {
        TreeMobileElement higherElement = this.findTopMostElement(element1, element2, x, y);
        return higherElement == element1;
    }

    private TreeMobileElement findTopMostElement(TreeMobileElement element1, TreeMobileElement element2, int x, int y) {
        double distance2;
        if (this.isAncestor(element1, element2)) {
            return element1;
        }
        if (this.isAncestor(element2, element1)) {
            return element2;
        }
        if (this.isClickInsideItsParent(element1, x, y) && !this.isClickInsideItsParent(element2, x, y)) {
            return element1;
        }
        if (this.isClickInsideItsParent(element2, x, y) && !this.isClickInsideItsParent(element1, x, y)) {
            return element2;
        }
        if (this.isVisibleElement(element1) && !this.isVisibleElement(element2)) {
            return element1;
        }
        if (this.isVisibleElement(element2) && !this.isVisibleElement(element1)) {
            return element2;
        }
        Rectangle rect1 = this.getElementRealBounds(element1);
        Rectangle rect2 = this.getElementRealBounds(element2);
        if (rect1.x >= rect2.x && rect1.width < rect2.width && rect1.y >= rect2.y && rect1.height < rect2.height) {
            return element1;
        }
        if (rect2.x >= rect1.x && rect2.width < rect1.width && rect2.y >= rect1.y && rect2.height < rect1.height) {
            return element2;
        }
        double distance1 = this.findNearestDistance(element1, x, y);
        return distance1 > (distance2 = this.findNearestDistance(element2, x, y)) ? element2 : element1;
    }

    private boolean isVisibleElement(TreeMobileElement element) {
        String type = element.getAttributes().get("type");
        if (StringUtils.startsWith((CharSequence)type, (CharSequence)"XCUI") && !StringUtils.equals((CharSequence)type, (CharSequence)"XCUIElementTypeOther")) {
            return true;
        }
        return !element.getChildrenElement().isEmpty();
    }

    private boolean isClickInsideItsParent(TreeMobileElement element, int x, int y) {
        TreeMobileElement parent = element.getParentElement();
        Rectangle elementBounds = this.getElementRealBounds(element);
        while (parent != null) {
            Rectangle parentBounds = this.getElementRealBounds(parent);
            if (parentBounds.isEmpty()) {
                parent = parent.getParentElement();
                continue;
            }
            if (!parentBounds.intersects(elementBounds) || !parentBounds.contains(x, y)) {
                return false;
            }
            parent = parent.getParentElement();
        }
        return true;
    }

    private boolean isAncestor(TreeMobileElement element, TreeMobileElement ancestor) {
        TreeMobileElement parent = element.getParentElement();
        while (parent != null) {
            if (parent == ancestor) {
                return true;
            }
            parent = parent.getParentElement();
        }
        return false;
    }

    private boolean isPointInElementBounds(TreeMobileElement currentElement, int x, int y) {
        if (currentElement.getAttributes() == null) {
            return false;
        }
        Rectangle rectangle = this.getElementRealBounds(currentElement);
        return rectangle.contains(x, y);
    }

    public Rectangle getElementBounds(MobileElement currentElement) {
        if (currentElement == null) {
            return new Rectangle(0, 0, 0, 0);
        }
        Map<String, String> attributes = currentElement.getAttributes();
        Double elementX = attributes.containsKey("x") ? Double.parseDouble(attributes.get("x")) : 0.0;
        Double elementY = attributes.containsKey("y") ? Double.parseDouble(attributes.get("y")) : 0.0;
        Double elementWidth = attributes.containsKey("width") ? Double.parseDouble(attributes.get("width")) : 0.0;
        Double elementHeight = attributes.containsKey("height") ? Double.parseDouble(attributes.get("height")) : 0.0;
        Rectangle rectangle = new Rectangle(MobileDeviceDialog.safeRoundDouble(elementX), MobileDeviceDialog.safeRoundDouble(elementY), MobileDeviceDialog.safeRoundDouble(elementWidth), MobileDeviceDialog.safeRoundDouble(elementHeight));
        return rectangle;
    }

    public Rectangle getElementRealBounds(TreeMobileElement element) {
        Rectangle elementRect = this.getElementBounds(element);
        if (elementRect.isEmpty()) {
            return elementRect;
        }
        String type = element.getAttributes().get("type");
        if (StringUtils.startsWith((CharSequence)type, (CharSequence)"XCUI") && !StringUtils.equals((CharSequence)type, (CharSequence)"XCUIElementTypeOther")) {
            return elementRect;
        }
        List<? extends TreeMobileElement> children = element.getChildrenElement();
        if (children.isEmpty()) {
            return elementRect;
        }
        boolean isVirtualContainer = children.stream().allMatch(childI -> {
            String typeI = childI.getAttributes().get("type");
            return StringUtils.equals((CharSequence)typeI, (CharSequence)"XCUIElementTypeOther");
        });
        if (!isVirtualContainer) {
            return elementRect;
        }
        int minChildX = 9999;
        int maxChildX = 0;
        int minChildY = 9999;
        int maxChildY = 0;
        for (TreeMobileElement treeMobileElement : children) {
            Rectangle childRect = this.getElementRealBounds(treeMobileElement);
            minChildX = Math.min(minChildX, childRect.x);
            minChildY = Math.min(minChildY, childRect.y);
            maxChildX = Math.max(maxChildX, childRect.x + childRect.width);
            maxChildY = Math.max(maxChildY, childRect.y + childRect.height);
        }
        elementRect.x = Math.max(elementRect.x, minChildX);
        elementRect.y = Math.max(elementRect.y, minChildY);
        elementRect.width = maxChildX - elementRect.x;
        elementRect.height = maxChildY - elementRect.y;
        return elementRect;
    }
}

