/*
 * Decompiled with CFR 0.152.
 */
package org.zeroturnaround.process;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zeroturnaround.process.Stopwatch;
import org.zeroturnaround.process.SystemProcess;

public class ProcessUtil {
    private static final Logger log = LoggerFactory.getLogger(ProcessUtil.class);

    public static void waitFor(SystemProcess process) throws InterruptedException {
        log.info("Waiting for {} to finish.", (Object)process);
        ProcessUtil.waitFor(process, Stopwatch.createStarted(), "{} finished");
    }

    public static void waitFor(SystemProcess process, long timeout, TimeUnit unit) throws InterruptedException, TimeoutException {
        log.info("Waiting for {} to finish.", (Object)process);
        ProcessUtil.waitFor(process, Stopwatch.createStarted(), timeout, unit, "{} finished", "%s did not finish");
    }

    public static void destroyGracefullyAndWait(SystemProcess process) throws IOException, InterruptedException {
        Stopwatch sw = Stopwatch.createStarted();
        process.destroyGracefully();
        ProcessUtil.waitFor(process, sw, "Destroyed {} gracefully");
    }

    public static void destroyGracefullyAndWait(SystemProcess process, long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        Stopwatch sw = Stopwatch.createStarted();
        process.destroyGracefully();
        ProcessUtil.waitFor(process, sw, timeout, unit, "Destroyed {} gracefully", "Could not destroy %s gracefully");
    }

    public static void destroyForcefullyAndWait(SystemProcess process) throws IOException, InterruptedException {
        Stopwatch sw = Stopwatch.createStarted();
        process.destroyForcefully();
        ProcessUtil.waitFor(process, sw, "Destroyed {} forcefully");
    }

    public static void destroyForcefullyAndWait(SystemProcess process, long timeout, TimeUnit unit) throws IOException, InterruptedException, TimeoutException {
        Stopwatch sw = Stopwatch.createStarted();
        process.destroyForcefully();
        ProcessUtil.waitFor(process, sw, timeout, unit, "Destroyed {} forcefully", "Could not destroy %s forcefully");
    }

    public static void destroyGracefullyOrForcefullyAndWait(SystemProcess process) throws IOException, InterruptedException {
        try {
            ProcessUtil.destroyGracefullyAndWait(process);
            return;
        }
        catch (UnsupportedOperationException e) {
            log.trace("Destroying {}\u00a0gracefully is unsupported, trying forcefully:", (Object)process);
        }
        catch (Exception e) {
            log.error("Could not destroy {}\u00a0gracefully, trying forcefully:", (Object)process, (Object)e);
        }
        ProcessUtil.destroyForcefullyAndWait(process);
    }

    public static void destroyGracefullyOrForcefullyAndWait(SystemProcess process, long gracefulTimeout, TimeUnit gracefulTimeoutUnit) throws IOException, InterruptedException {
        if (ProcessUtil.tryDestroyGracefully(process, gracefulTimeout, gracefulTimeoutUnit)) {
            return;
        }
        ProcessUtil.destroyForcefullyAndWait(process);
    }

    public static void destroyGracefullyOrForcefullyAndWait(SystemProcess process, long gracefulTimeout, TimeUnit gracefulTimeoutUnit, long forcefulTimeout, TimeUnit forcefulTimeoutUnit) throws IOException, InterruptedException, TimeoutException {
        if (ProcessUtil.tryDestroyGracefully(process, gracefulTimeout, gracefulTimeoutUnit)) {
            return;
        }
        ProcessUtil.destroyForcefullyAndWait(process, forcefulTimeout, forcefulTimeoutUnit);
    }

    private static boolean tryDestroyGracefully(SystemProcess killer, long gracefulTimeout, TimeUnit gracefulTimeoutUnit) {
        try {
            ProcessUtil.destroyGracefullyAndWait(killer, gracefulTimeout, gracefulTimeoutUnit);
            return true;
        }
        catch (UnsupportedOperationException e) {
            log.trace("Destroying {}\u00a0gracefully is unsupported, trying forcefully:", (Object)killer);
        }
        catch (TimeoutException e) {
            log.info(e.getMessage() + ", trying forcefully.");
        }
        catch (Exception e) {
            log.error("Could not destroy {}\u00a0gracefully, trying forcefully.", (Object)killer, (Object)e);
        }
        return false;
    }

    private static void waitFor(SystemProcess process, Stopwatch sw, String successFormat) throws InterruptedException {
        process.waitFor();
        long duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
        log.info(successFormat + " in {} ms.", (Object)process, (Object)duration);
    }

    private static void waitFor(SystemProcess process, Stopwatch sw, long timeout, TimeUnit unit, String successFormat, String timeoutFormat) throws InterruptedException, TimeoutException {
        if (!process.waitFor(timeout, unit)) {
            throw new TimeoutException(String.format(timeoutFormat + " in %d %s", process, timeout, unit.toString().toLowerCase()));
        }
        long duration = sw.stop().elapsed(TimeUnit.MILLISECONDS);
        log.info(successFormat + " in {} ms.", (Object)process, (Object)duration);
    }
}

