package com.kms.katalon.core.helper.screenrecorder;

public enum VideoFileFormat {
	WEBM("WEBM", ".webm"), AVI("AVI", ".avi"), MOV("MOV", ".mov"), MP4("MP4", ".mp4");

    private String name;

    private String extension;

    private VideoFileFormat(String name, String extension) {
        this.name = name;
        this.extension = extension;
    }

    public String getName() {
        return name;
    }

    public String getExtension() {
        return extension;
    }

    @Override
    public String toString() {
        return getName();
    }

    // Method to convert a string to a VideoFileFormat
    public static VideoFileFormat fromString(String input) {
        for (VideoFileFormat format : values()) {
            if (format.toString().equalsIgnoreCase(input)) {
                return format;
            }
        }
        throw new IllegalArgumentException("No VideoFileFormat with name: " + input);
    }
}
