package com.kms.katalon.core.keyword.internal;

import java.util.HashMap;
import java.util.Map;

import com.kms.katalon.core.constants.CoreConstants;

import groovy.transform.CompileStatic;

public class KeywordExecutionContext {
    private static final String TESTNG_PLATFORM_NAME = "testng";

    private static final String CUCUMBER_PLATFORM_NAME = "cucumber";

    private static final Map<String, String> PLATFORM_NAME_MAP = new HashMap<String, String>();
    static {
        PLATFORM_NAME_MAP.put(CoreConstants.PLATFORM_BUILT_IN, "builtin");
        PLATFORM_NAME_MAP.put(CoreConstants.PLATFORM_WEB, "web_ui");
        PLATFORM_NAME_MAP.put(CoreConstants.PLATFORM_MOBILE, "mobile");
        PLATFORM_NAME_MAP.put(CoreConstants.PLATFORM_WINDOWS, "windows");
        PLATFORM_NAME_MAP.put(CoreConstants.PLATFORM_WEB_SERVICE, "web_service");
    }

    private static String runningKeyword;

    private static String runningPlatform;

    private static boolean hasHealedSomeObjects = false;

    private static boolean isUsingApplitools;

    private static Map<String, Boolean> keywordsUsage = new HashMap<String, Boolean>();
    static {
        markKeywordsUsage(CoreConstants.PLATFORM_BUILT_IN, false);
        markKeywordsUsage(CoreConstants.PLATFORM_WEB, false);
        markKeywordsUsage(CoreConstants.PLATFORM_MOBILE, false);
        markKeywordsUsage(CoreConstants.PLATFORM_WINDOWS, false);
        markKeywordsUsage(CoreConstants.PLATFORM_WEB_SERVICE, false);
        markKeywordsUsage(TESTNG_PLATFORM_NAME, false);
        markKeywordsUsage(CUCUMBER_PLATFORM_NAME, false);
    }

    public static void saveRunningKeywordAndPlatform(String runningPlatform, String runningKeyword) {
        KeywordExecutionContext.runningPlatform = runningPlatform;
        KeywordExecutionContext.runningKeyword = runningKeyword;
    }

    public static String getRunningKeyword() {
        return runningKeyword;
    }

    public static void setRunningKeyword(String runningKeyword) {
        KeywordExecutionContext.runningKeyword = runningKeyword;
    }

    public static String getRunningPlatform() {
        return runningPlatform;
    }

    public static void setRunningPlatform(String runningPlatform) {
        KeywordExecutionContext.runningPlatform = runningPlatform;
    }

    public static boolean isRunningWebUI() {
        return runningPlatform.equals(CoreConstants.PLATFORM_WEB);
    }

    public static boolean isRunningMobile() {
        return runningPlatform.equals(CoreConstants.PLATFORM_MOBILE);
    }

    @CompileStatic
    public static boolean hasHealedSomeObjects() {
        return hasHealedSomeObjects;
    }

    @CompileStatic
    public static void setHasHealedSomeObjects(boolean hasHealedSomeObjects) {
        KeywordExecutionContext.hasHealedSomeObjects = hasHealedSomeObjects;
    }

    public static void resetKeywordsUsage() {
        PLATFORM_NAME_MAP.forEach((platform, hasUsage) -> {
            markKeywordsUsage(platform, false);
        });
    }

    public static void markKeywordsUsage(String platform) {
        markKeywordsUsage(platform, true);
    }

    public static void markKeywordsUsage(String platform, boolean hasUsed) {
        String truePlatform = PLATFORM_NAME_MAP.containsKey(platform) ? PLATFORM_NAME_MAP.get(platform) : platform;
        keywordsUsage.put(truePlatform, hasUsed);
    }

    public static Map<String, Boolean> getKeywordsUsage() {
        return keywordsUsage;
    }

    public static void setUsingApplitools(boolean isUsingApplitools) {
        KeywordExecutionContext.isUsingApplitools = isUsingApplitools;
    }

    public static boolean isUsingApplitools() {
        return isUsingApplitools;
    }

    public static void resetUsingApplitools() {
        isUsingApplitools = false;
    }
}
