package com.kms.katalon.core.model.internal;

import java.util.List;

/**
 * @apiNote **INTERNAL USE ONLY.** Do not use this class in client code.
 */
public class WindowsPlatformExecutionSettings {
    public WindowsPlatformExecutionSettings(int elementTimeoutInSeconds, int actionDelayInMillis,
            List<String> actionDelayAffectedKeywords) {
        super();
        this.elementTimeoutInSeconds = elementTimeoutInSeconds;
        this.actionDelayInMillis = actionDelayInMillis;
        this.actionDelayAffectedKeywords = actionDelayAffectedKeywords;
    }

    // Element timeout
    private int elementTimeoutInSeconds;

    // Action delay (per keyword)
    private int actionDelayInMillis;

    private List<String> actionDelayAffectedKeywords;

    public int getElementTimeoutInSeconds() {
        return elementTimeoutInSeconds;
    }

    public void setElementTimeoutInSeconds(int elementTimeoutInSeconds) {
        this.elementTimeoutInSeconds = elementTimeoutInSeconds;
    }

    public int getActionDelayInMillis() {
        return actionDelayInMillis;
    }

    public void setActionDelayInMillis(int actionDelayInMillis) {
        this.actionDelayInMillis = actionDelayInMillis;
    }

    public List<String> getActionDelayAffectedKeywords() {
        return actionDelayAffectedKeywords;
    }

    public void setActionDelayAffectedKeywords(List<String> actionDelayAffectedKeywords) {
        this.actionDelayAffectedKeywords = actionDelayAffectedKeywords;
    }

    public static class Builder {
        private int elementTimeoutInSeconds;

        private int actionDelayInMillis;

        private List<String> actionDelayAffectedKeywords;

        public Builder() {
        }

        public Builder elementTimeoutInSeconds(int elementTimeoutInSeconds) {
            this.elementTimeoutInSeconds = elementTimeoutInSeconds;
            return this;
        }

        public Builder actionDelayInMillis(int actionDelayInMillis) {
            this.actionDelayInMillis = actionDelayInMillis;
            return this;
        }

        public Builder actionDelayAffectedKeywords(List<String> actionDelayAffectedKeywords) {
            this.actionDelayAffectedKeywords = actionDelayAffectedKeywords;
            return this;
        }

        public WindowsPlatformExecutionSettings build() {
            return new WindowsPlatformExecutionSettings(elementTimeoutInSeconds, actionDelayInMillis,
                    actionDelayAffectedKeywords);
        }
    }
}
