package com.kms.katalon.core.setting;

import org.apache.commons.lang3.StringUtils;

import com.kms.katalon.core.constants.StudioAssistPreferenceConstants;
import com.kms.katalon.core.preferences.PreferenceStoreManager;
import com.kms.katalon.core.preferences.ScopedPreferenceStore;

public class StudioAssistSetting {
    
    public static boolean isGenerateCode() {
        return getStudioAssistTagSelectionPreference(StudioAssistPreferenceConstants.GENERATE_CODE);
    }

    public static boolean isApiTestCaseGeneration() {
        return getStudioAssistTagSelectionPreference(StudioAssistPreferenceConstants.API_TEST_CASE_GENERATION);
    }

    public static boolean isApiTestCaseDefaultTag() {
        return getStudioAssistTagSelectionPreference(StudioAssistPreferenceConstants.API_TEST_DEFAULT_TAG_ENABLED);
    }

    public static boolean isApiTestCaseCustomTag() {
        return getStudioAssistTagSelectionPreference(StudioAssistPreferenceConstants.API_TEST_CUSTOM_TAG_ENABLED);
    }

    public static boolean isCodeGenerationDefaultTag() {
        return getStudioAssistTagSelectionPreference(StudioAssistPreferenceConstants.GENERATE_CODE_DEFAULT_TAG_ENABLED);
    }

    public static boolean isCodeGenerationCustomTag() {
        return getStudioAssistTagSelectionPreference(StudioAssistPreferenceConstants.GENERATE_CODE_CUSTOM_TAG_ENABLED);
    }

    public static String getApiTestCustomTag() {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);

        return scopedPreferenceStore.getString(StudioAssistPreferenceConstants.API_TEST_CUSTOM_TAG_TEXT);
    }

    public static String getGenerateCodeCustomTag() {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);

        return scopedPreferenceStore.getString(StudioAssistPreferenceConstants.GENERATE_CODE_CUSTOM_TAG_TEXT);
    }

    public static boolean isProjectContextObjectRepositoriesEnabled() {
        return isProjectContextObjectRepositoriesEnabled(true);
    }

    public static boolean isProjectContextObjectRepositoriesEnabled(boolean defaultValue) {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);

        String rawValue = scopedPreferenceStore
                .getString(StudioAssistPreferenceConstants.STUDIOASSIST_PROJECT_CONTEXT_OBJECT_REPOSITORY);

        if (StringUtils.isBlank(rawValue)) {
            return defaultValue;
        }
        return Boolean.valueOf(rawValue);
    }

    public static boolean isProjectContextCustomKeywordsEnabled() {
        return isProjectContextCustomKeywordsEnabled(true);
    }

    public static boolean isProjectContextCustomKeywordsEnabled(boolean defaultValue) {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);

        String rawValue = scopedPreferenceStore
                .getString(StudioAssistPreferenceConstants.STUDIOASSIST_PROJECT_CONTEXT_CUSTOM_KEYWORDS);

        if (StringUtils.isBlank(rawValue)) {
            return defaultValue;
        }
        return Boolean.valueOf(rawValue);
    }

    private static boolean getStudioAssistTagSelectionPreference(String preferenceKey) {
        if (StringUtils.isBlank(preferenceKey))
            return false;

        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);

        String defaultTag = scopedPreferenceStore.getString(preferenceKey);

        if (StringUtils.isEmpty(defaultTag) || defaultTag.equals("true")) {
            return true;
        }
        return false;
    }
    
    public static boolean isIncludeFocusingFileEnabled() {
        return isIncludeFocusingFileEnabled(true);
    }

    public static boolean isIncludeFocusingFileEnabled(boolean defaultValue) {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);

        String rawValue = scopedPreferenceStore
                .getString(StudioAssistPreferenceConstants.STUDIOASSIST_PROJECT_CONTEXT_INCLUDE_FOCUSING_FILE);
        if (StringUtils.isBlank(rawValue)) {
            return defaultValue;
        }
        return Boolean.valueOf(rawValue);
    }

    public static void toggleIncludeCurrentFile(boolean isEnabled) {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);
        scopedPreferenceStore.setValue(
                StudioAssistPreferenceConstants.STUDIOASSIST_PROJECT_CONTEXT_INCLUDE_FOCUSING_FILE,
                String.valueOf(isEnabled));
    }
    
    public static boolean shouldDisplayAttachmentBadge() {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);
        boolean usedAttachmentButtonBefore = scopedPreferenceStore
                .getBoolean(StudioAssistPreferenceConstants.STUDIOASSIST_USED_ATTACHMENT_BUTTON);
        return !usedAttachmentButtonBefore;
    }

    public static void setToHideAttachmentBadge() {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);
        scopedPreferenceStore.setValue(StudioAssistPreferenceConstants.STUDIOASSIST_USED_ATTACHMENT_BUTTON, true);
    }
    
    public static boolean isFollowUpQuestionEnabled() {
        return isFollowUpQuestionEnabled(true);
    }

    public static boolean isFollowUpQuestionEnabled(boolean defaultValue) {
        ScopedPreferenceStore scopedPreferenceStore = PreferenceStoreManager
                .getPreferenceStore(StudioAssistPreferenceConstants.STUDIO_ASSIST_TAG);

        String rawValue = scopedPreferenceStore
                .getString(StudioAssistPreferenceConstants.STUDIOASSIST_FOLLOW_UP_QUESTION_ENABLED);

        if (StringUtils.isBlank(rawValue)) {
            return defaultValue;
        }
        return Boolean.valueOf(rawValue);
    }
}
