package com.kms.katalon.core.testobject;

import com.google.gson.annotations.Expose;
import com.google.gson.annotations.SerializedName;

public class BrokenTestObject {

    @SerializedName("approved")
    @Expose
    private Boolean approved;

    @SerializedName("testObjectId")
    @Expose
    private String testObjectId;

    @SerializedName("brokenLocator")
    @Expose
    private String brokenLocator;

    @SerializedName("brokenLocatorMethod")
    @Expose
    private String brokenLocatorMethod;

    @SerializedName("proposedLocator")
    @Expose
    private String proposedLocator;

    @SerializedName("proposedLocatorMethod")
    @Expose
    private String proposedLocatorMethod;

    @SerializedName("recoveryMethod")
    @Expose
    private String recoveryMethod;

    @SerializedName("pathToScreenshot")
    @Expose
    private String pathToScreenshot;

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }

        if (obj == null) {
            return false;
        }

        if (getClass() != obj.getClass()) {
            return false;
        }

        BrokenTestObject other = (BrokenTestObject) obj;
        if (approved == null) {
            if (other.approved != null) {
                return false;
            }
        } else if (!approved.equals(other.approved)) {
            return false;
        }

        if (brokenLocator == null) {
            if (other.brokenLocator != null) {
                return false;
            }
        } else if (!brokenLocator.equals(other.brokenLocator)) {
            return false;
        }

        if (brokenLocatorMethod == null) {
            if (other.brokenLocatorMethod != null) {
                return false;
            }
        } else if (!brokenLocatorMethod.equals(other.brokenLocatorMethod)) {
            return false;
        }

        if (proposedLocator == null) {
            if (other.proposedLocator != null) {
                return false;
            }
        } else if (!proposedLocator.equals(other.proposedLocator)) {
            return false;
        }

        if (proposedLocatorMethod == null) {
            if (other.proposedLocatorMethod != null) {
                return false;
            }
        } else if (!proposedLocatorMethod.equals(other.proposedLocatorMethod)) {
            return false;
        }

        if (recoveryMethod == null) {
            if (other.recoveryMethod != null) {
                return false;
            }
        } else if (!recoveryMethod.equals(other.recoveryMethod)) {
            return false;
        }

        if (testObjectId == null) {
            if (other.testObjectId != null) {
                return false;
            }
        } else if (!testObjectId.equals(other.testObjectId)) {
            return false;
        }

        return true;
    }

    @Override
    public BrokenTestObject clone() {
        BrokenTestObject clone = new BrokenTestObject();
        clone.setApproved(this.approved);
        clone.setTestObjectId(this.testObjectId);
        clone.setBrokenLocator(this.brokenLocator);
        clone.setBrokenLocatorMethod(this.brokenLocatorMethod);
        clone.setProposedLocator(this.proposedLocator);
        clone.setProposedLocatorMethod(this.proposedLocatorMethod);
        clone.setRecoveryMethod(this.recoveryMethod);
        clone.setPathToScreenshot(this.pathToScreenshot);
        return clone;
    }

    public Boolean getApproved() {
        return approved;
    }

    public String getBrokenLocator() {
        return brokenLocator;
    }

    public String getBrokenLocatorMethod() {
        return brokenLocatorMethod;
    }

    public String getPathToScreenshot() {
        return pathToScreenshot;
    }

    public String getProposedLocator() {
        return proposedLocator;
    }

    public String getProposedLocatorMethod() {
        return proposedLocatorMethod;
    }

    public String getRecoveryMethod() {
        return recoveryMethod;
    }

    public String getTestObjectId() {
        return testObjectId;
    }

    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((approved == null) ? 0 : approved.hashCode());
        result = prime * result + ((brokenLocator == null) ? 0 : brokenLocator.hashCode());
        result = prime * result + ((brokenLocatorMethod == null) ? 0 : brokenLocatorMethod.hashCode());
        result = prime * result + ((proposedLocator == null) ? 0 : proposedLocator.hashCode());
        result = prime * result + ((proposedLocatorMethod == null) ? 0 : proposedLocatorMethod.hashCode());
        result = prime * result + ((recoveryMethod == null) ? 0 : recoveryMethod.hashCode());
        result = prime * result + ((testObjectId == null) ? 0 : testObjectId.hashCode());
        return result;
    }

    public void setApproved(Boolean approved) {
        this.approved = approved;
    }

    public void setBrokenLocator(String brokenLocator) {
        this.brokenLocator = brokenLocator;
    }

    public void setBrokenLocatorMethod(String brokenLocatorMethod) {
        this.brokenLocatorMethod = brokenLocatorMethod;
    }

    public void setPathToScreenshot(String pathToScreenshot) {
        this.pathToScreenshot = pathToScreenshot;
    }

    public void setProposedLocator(String proposedLocator) {
        this.proposedLocator = proposedLocator;
    }

    public void setProposedLocatorMethod(String proposedLocatorMethod) {
        this.proposedLocatorMethod = proposedLocatorMethod;
    }

    public void setRecoveryMethod(String recoveryMethod) {
        this.recoveryMethod = recoveryMethod;
    }

    public void setTestObjectId(String testObjectId) {
        this.testObjectId = testObjectId;
    }
}
