package com.kms.katalon.core.testobject;

import java.io.Serializable;
import java.util.List;

import org.apache.commons.lang3.StringUtils;

public class ValidationStep implements Serializable {
    private static final long serialVersionUID = 1L;

    public String id;

    public String name;

    public ValidationType type;

    public ValidationDataType dataType;

    public ValidationTarget target;

    public String data;

    public boolean activate;

    public transient List<ValidationResult> results;

    public ValidationStep() {

    }

    public ValidationStep(String id, String name, ValidationType type, ValidationDataType dataType, String data) {
        super();
        this.id = id;
        this.name = name;
        this.type = type;
        this.dataType = dataType;
        this.data = data;
        this.activate = false;
        this.target = ValidationTarget.RESPONSE;
    }
    
    @Override
    public int hashCode() {
        final int prime = 31;
        int result = 1;
        result = prime * result + ((id == null) ? 0 : id.hashCode());
        return result;
    }

    @Override
    public boolean equals(Object target) {
        if (!(target instanceof ValidationStep)) {
            return false;
        }
        return StringUtils.equals(this.id, ((ValidationStep) target).id);
    }   
}
