package com.kms.katalon.core.testobject.impl;

/**
 * Represents the body content of a HTTP message (request/response) that obtains content from a {@link String}.
 * This class is used for validating GraphQL query in request body using displayText
 * 
 * @since 5.4
 */
public class HttpGraphQLBodyContent extends HttpTextBodyContent {
    private String displayText;

    public HttpGraphQLBodyContent(String text, String charset, String contentType, String displayText) {
        super(text, charset, contentType);
        this.displayText = displayText;
    }

    public HttpGraphQLBodyContent(String text, String charset, String contentType) {
        super(text, charset, contentType);
    }

    public HttpGraphQLBodyContent(String text, String charset) {
        super(text, charset);
    }

    public HttpGraphQLBodyContent(String text) {
        super(text);
    }
    
    public String getDisplayText() {
        return displayText;
    }
    
    public void setDisplayText(String displayText) {
        this.displayText = displayText;
    }
}
