package com.kms.katalon.core.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class NodeUtils {
    public static interface NodeVerifier<NodeType> {
        public boolean test(NodeType root);
    }

    public interface ChildrenNodeProvider<NodeType> {
        public Iterable<NodeType> get(NodeType parent);
    }

    public static <NodeType> NodeType find(NodeType root, NodeVerifier<NodeType> finder,
            ChildrenNodeProvider<NodeType> childrenProvider) {
        var founds = findAll(root, finder, childrenProvider, true);
        return founds.isEmpty() ? null : founds.get(0);
    }

    public static <NodeType> NodeType find(Iterable<NodeType> items, NodeVerifier<NodeType> finder,
            ChildrenNodeProvider<NodeType> childrenProvider) {
        var founds = findAll(items, finder, childrenProvider, true);
        return founds.isEmpty() ? null : founds.get(0);
    }

    public static <NodeType> List<NodeType> findAll(NodeType root, NodeVerifier<NodeType> finder,
            ChildrenNodeProvider<NodeType> childrenProvider) {
        return findAll(root, finder, childrenProvider, false);
    }

    public static <NodeType> List<NodeType> findAll(Iterable<NodeType> items, NodeVerifier<NodeType> finder,
            ChildrenNodeProvider<NodeType> childrenProvider) {
        return findAll(items, finder, childrenProvider, false);
    }

    private static <NodeType> List<NodeType> findAll(NodeType root, NodeVerifier<NodeType> finder,
            ChildrenNodeProvider<NodeType> childrenProvider, boolean findFirst) {
        var founds = new ArrayList<NodeType>();

        if (finder.test(root)) {
            founds.add(root);
            if (findFirst) {
                return founds;
            }
        }

        if (childrenProvider != null) {
            founds.addAll(findAll(childrenProvider.get(root), finder, childrenProvider, findFirst));
        }

        return founds;
    }

    private static <NodeType> List<NodeType> findAll(Iterable<NodeType> items, NodeVerifier<NodeType> finder,
            ChildrenNodeProvider<NodeType> childrenProvider, boolean findFirst) {
        var founds = new ArrayList<NodeType>();

        if (items == null) {
            return founds;
        }

        for (var item : items) {
            founds.addAll(findAll(item, finder, childrenProvider, findFirst));
            if (findFirst && !founds.isEmpty()) {
                return new ArrayList<>(Arrays.asList(founds.get(0)));
            }
        }
        return founds;
    }
}
