package com.kms.katalon.core.util.internal;

import graphql.schema.GraphQLSchema;
import graphql.schema.idl.SchemaParser;
import graphql.schema.idl.TypeDefinitionRegistry;
import graphql.schema.idl.UnExecutableSchemaGenerator;

public class GraphQLUtil {

    public GraphQLUtil() {
    }

    public static boolean isValidGraphQLSchema(String schema) {
        try {
            TypeDefinitionRegistry definitionRegistry = new SchemaParser().parse(schema);
            GraphQLSchema qlSchema = UnExecutableSchemaGenerator.makeUnExecutableSchema(definitionRegistry);
            return qlSchema != null;
        } catch (Exception e) {
            return false;
        }
    }
}
