package com.kms.katalon.core.mobile.keyword.builtin

import org.openqa.selenium.Point

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.mobile.constants.StringConstants
import com.kms.katalon.core.mobile.helper.MobileCommonHelper
import com.kms.katalon.core.mobile.keyword.internal.MobileAbstractKeyword
import com.kms.katalon.core.mobile.keyword.internal.MobileKeywordMain
import com.kms.katalon.core.model.FailureHandling

import groovy.transform.CompileStatic
import io.appium.java_client.AppiumDriver
import io.appium.java_client.android.AndroidDriver
import io.appium.java_client.ios.IOSDriver
import io.appium.java_client.remote.SupportsContextSwitching

@Action(value = "openNotifications")
public class OpenNotificationsKeyword extends MobileAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        openNotifications(flowControl)
    }

    @CompileStatic
    public void openNotifications(FailureHandling flowControl) throws StepFailedException {
        MobileKeywordMain.runKeyword({
            AppiumDriver driver = getAnyAppiumDriver()
            if (driver instanceof AndroidDriver) {
                AndroidDriver androidDriver = (AndroidDriver) driver
                Object version = androidDriver.getCapabilities().getCapability("platformVersion")
                if (version != null) {
                    ((AndroidDriver) driver).openNotifications()
                } else {
                    int height = driver.manage().window().getSize().height;
                    MobileCommonHelper.swipe(driver, new Point(50, 1), new Point(50, height - 1))
                }
            } else if (driver instanceof IOSDriver) {
                int height = driver.manage().window().getSize().height;
                MobileCommonHelper.swipe(driver, new Point(50, 1), new Point(50, height - 1));
            }
            logger.logPassed(StringConstants.KW_MSG_PASSED_OPEN_NOTIFICATIONS)
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), StringConstants.KW_MSG_CANNOT_OPEN_NOTIFICATIONS)
    }
}
