package com.kms.katalon.core.mobile.util;

import java.io.File;
import java.util.regex.Pattern;

import com.kms.katalon.constants.IdConstants;
import com.kms.katalon.core.mobile.driver.MobileDriverType;
import com.kms.katalon.core.setting.PropertySettingStoreUtil;

public class MobileRunConfigurationUtil {
    public static final String CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH = PropertySettingStoreUtil.EXTERNAL_SETTING_ROOT_FOLDER_NAME
            + File.separator + "execution";

    public static String REGEX_CUSTOM_EXECUTION_PROPERTIES_FILE = String.format("^%s\\.(android|ios).properties$",
            IdConstants.KATALON_MOBILE_BUNDLE_ID.replace(".", "\\."));

    public static boolean isAndroidPlatform(String aPlatform) {
        return aPlatform.equals(MobileDriverType.ANDROID_DRIVER.getPlatform());
    }

    public static boolean isiOSPlatform(String aPlatform) {
        return aPlatform.equals(MobileDriverType.IOS_DRIVER.getPlatform());
    }

    public static String getRegexToVerifyCustomExecutionFile() {
        return REGEX_CUSTOM_EXECUTION_PROPERTIES_FILE;
    }

    public static boolean usingCustomRunConfigurationId(String runConfigId, String projectFolderLocation) {
        File customProfileSettingFolder = new File(
                projectFolderLocation + File.separator + CUSTOM_EXECUTION_CONFIG_ROOT_FOLDER_RELATIVE_PATH);
        if (!customProfileSettingFolder.exists() || !customProfileSettingFolder.isDirectory()) {
            return false;
        }

        for (File customProfile : customProfileSettingFolder.listFiles()) {
            if (customProfile.isDirectory() && !customProfile.isHidden()
                    && runConfigId.equals(customProfile.getName())) {
                for (File propertiesFile : customProfile.listFiles()) {
                    Pattern pattern = Pattern.compile(MobileRunConfigurationUtil.getRegexToVerifyCustomExecutionFile());
                    if (!propertiesFile.isFile() || propertiesFile.isHidden()) {
                        continue;
                    }

                    if (pattern.matcher(propertiesFile.getName()).matches()) {
                        return true;
                    }
                }
            }
        }

        return false;
    }
}
