package com.kms.katalon.core.webservice.keyword.builtin;

import java.text.MessageFormat
import java.util.stream.Collectors

import com.atlassian.oai.validator.model.Request
import com.atlassian.oai.validator.report.ValidationReport
import com.kms.katalon.core.annotation.internal.Action;
import com.kms.katalon.core.keyword.internal.KeywordMain
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.logging.ErrorCollector
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.setting.ReportBundleSettingStore
import com.kms.katalon.core.testobject.RequestObject
import com.kms.katalon.core.testobject.ResponseObject
import com.kms.katalon.core.testobject.ValidationDataType
import com.kms.katalon.core.testobject.ValidationResult
import com.kms.katalon.core.testobject.ValidationStatus
import com.kms.katalon.core.testobject.ValidationTarget
import com.kms.katalon.core.testobject.ValidationType
import com.kms.katalon.core.webservice.constants.CoreWebserviceMessageConstants
import com.kms.katalon.core.webservice.keyword.internal.WebserviceAbstractKeyword;
import com.kms.katalon.core.webservice.util.OpenAPIUtil

import graphql.ThreadSafe
import groovy.transform.CompileStatic
import io.swagger.v3.parser.exception.EncodingNotSupportedException

@Action(value = "validateOpenAPIAgainstSpecification")
public class ValidateOpenAPIAgainstSpecificationKeyword extends WebserviceAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object... params) {
        FailureHandling flowControl = null;
        ValidationTarget target = (ValidationTarget) params[0];
        if (target == ValidationTarget.REQUEST) {
            RequestObject request = (RequestObject) params[1];
            String specSrc = params[2];
            flowControl = getFailureHandling(params, 3);
            return validateRequest(request, specSrc, flowControl);
        } else if (target == ValidationTarget.RESPONSE) {
            ResponseObject response = (ResponseObject) params[1];
            RequestObject request = (RequestObject) params[2];
            String specSrc = params[3];
            flowControl = getFailureHandling(params, 4);
            return validateResponse(response, request, specSrc, flowControl);
        }
        KeywordMain.stepFailed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_INVALID_VALIDATION_OBJECT, flowControl);
    }

    @CompileStatic
    private boolean validateRequest(RequestObject request, String specSrc, FailureHandling flowControl ) {
        return KeywordMain.runKeyword({
            ValidationReport report = OpenAPIUtil.validateRequest(request, specSrc);
            return verifyResult(report, flowControl);
        }, flowControl, CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_OPEN_API_SPEC_FAILED);
    }

    @CompileStatic
    private boolean validateResponse(ResponseObject response, RequestObject request, String specSrc, FailureHandling flowControl ) {
        return KeywordMain.runKeyword({
            ValidationReport report = OpenAPIUtil.validateResponse(response, request, specSrc);
            return verifyResult(report, flowControl);
        }, flowControl, CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_OPEN_API_SPEC_FAILED);
    }

    private boolean verifyResult(ValidationReport report, FailureHandling flowControl) {
        if (!report.hasErrors()) {
            logger.logPassed(CoreWebserviceMessageConstants.KW_LOG_VALIDATION_VALIDATE_OPEN_API_SPEC_SUCCESS);
            return true;
        }
        List<String> messages = report.getMessages().stream()
                .map({ resultI -> return resultI.getMessage() })
                .collect(Collectors.toList());

        String failedMessage = MessageFormat.format("{0} Issue(s):\r\n> {1}", report.getMessages().size(), String.join("\r\n> ", messages));

        KeywordMain.stepFailed(failedMessage, flowControl);
        return false;
    }
}
