package com.kms.katalon.core.webservice.verification;

import java.io.File;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Map;
import java.util.Objects;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.constants.StringConstants;
import com.kms.katalon.core.testobject.ObjectRepository;
import com.kms.katalon.core.testobject.RequestObject;
import com.kms.katalon.core.testobject.ResponseObject;
import com.kms.katalon.core.testobject.impl.HttpTextBodyContent;

public class WSResponseManager {

    private static final String REQUEST_OBJECT_FILE_EXTENSION = ".rs";

    private RequestObject request;

    private ResponseObject response;

    private static WSResponseManager instance;

    private WSResponseManager() {

    }

    public static WSResponseManager getInstance() {
        if (instance == null) {
            instance = new WSResponseManager();
        }
        return instance;
    }

    public ResponseObject getCurrentResponse() throws Exception {
        if (response == null) {
            String responseObjectJson = (String) RunConfiguration
                    .getProperty(StringConstants.WS_VERIFICATION_RESPONSE_OBJECT);

            Gson gson = new GsonBuilder().registerTypeAdapter(ResponseObject.class, new ResponseObjectInstanceCreator())
                    .create();
            response = gson.fromJson(responseObjectJson, ResponseObject.class);
        }

        return response;
    }

    public void setCurrentResponse(ResponseObject response) {
        this.response = response;
    }

    public RequestObject getCurrentRequest() throws Exception {
        if (request == null) {
            String requestObjectId = (String) RunConfiguration
                    .getProperty(StringConstants.WS_VERIFICATION_REQUEST_OBJECT_ID);
            File objectFile = new File(RunConfiguration.getProjectDir(),
                    requestObjectId + REQUEST_OBJECT_FILE_EXTENSION);
            request = ObjectRepository.findRequestObject(requestObjectId, objectFile);
        }

        return request;
    }

    public void setCurrentRequest(RequestObject request) {
        this.request = request;
    }

    private static class ResponseObjectInstanceCreator implements JsonDeserializer<ResponseObject> {

        @Override
        public ResponseObject deserialize(JsonElement arg0, Type arg1, JsonDeserializationContext context)
                throws JsonParseException {
            ResponseObject response = new ResponseObject();
            JsonObject jsObject = arg0.getAsJsonObject();

            if (Objects.nonNull(jsObject.get("contentType"))) {
                response.setContentType(jsObject.get("contentType").getAsString());
            }

            if (Objects.nonNull(jsObject.get("responseText"))) {
                response.setResponseText(jsObject.get("responseText").getAsString());
            }

            if (Objects.nonNull(jsObject.get("statusCode"))) {
                response.setStatusCode(jsObject.get("statusCode").getAsInt());
            }

            if (Objects.nonNull(jsObject.get("contentCharset"))) {
                response.setContentCharset(jsObject.get("contentCharset").getAsString());
            }

            if (Objects.nonNull(jsObject.get("responseHeaderSize"))) {
                response.setResponseHeaderSize(jsObject.get("responseHeaderSize").getAsLong());
            }

            if (Objects.nonNull(jsObject.get("responseBodySize"))) {
                response.setResponseBodySize(jsObject.get("responseBodySize").getAsLong());
            }

            if (Objects.nonNull(jsObject.get("waitingTime"))) {
                response.setWaitingTime(jsObject.get("waitingTime").getAsLong());
            }

            if (Objects.nonNull(jsObject.get("contentDownloadTime"))) {
                response.setContentDownloadTime(jsObject.get("contentDownloadTime").getAsLong());
            }

            Type mapType = new TypeToken<HttpTextBodyContent>() {}.getType();
            HttpTextBodyContent responseBodyContent = context.deserialize(jsObject.get("responseBodyContent"), mapType);
            response.setBodyContent(responseBodyContent);

            mapType = new TypeToken<Map<String, List<String>>>() {}.getType();
            Map<String, List<String>> headerFields = context.deserialize(jsObject.get("headerFields"), mapType);
            response.setHeaderFields(headerFields);

            return response;
        }
    }
}
