package com.kms.katalon.core.appium.util;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.lang.module.ModuleDescriptor.Version;

import org.apache.commons.lang3.StringUtils;

import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.kms.katalon.core.appium.constants.CoreAppiumMessageConstants;
import com.kms.katalon.core.configuration.RunConfiguration;

public class AppiumVersionUtil {
    private static final String PACKAGE_JSON_FILE_NAME = "package.json";

    private static final String VERSION_ELEMENT = "version";

    private static AppiumVersionUtil _instance;

    private static String appiumVersion;

    private static final String APPIUM_PREFIX = "appium:";

    private AppiumVersionUtil() {

    }

    public static AppiumVersionUtil getInstance() {
        if (_instance == null) {
            _instance = new AppiumVersionUtil();
        }

        return _instance;
    }

    public static void clearCachedVersion() {
        appiumVersion = null;
    }

    public String getAppiumDesiredCapabilityPrefix() {
        String prefix = StringUtils.EMPTY;
        try {
            prefix = isAppiumV1() ? StringUtils.EMPTY : APPIUM_PREFIX;
        } catch (IOException e) {
            // Ignore this
        }
        return prefix;
    }

    /*
     * "2.0.0-beta.26" is the first version of 2.x based on https://www.npmjs.com/package/appium?activeTab=versions
     * if comparing the current version to "2.0.0", versions that are 2.x-beta or 2.x-rc will be known as 1.x
     */
    public boolean isAppiumV1() throws IOException {
        return Version.parse(getAppiumVersion()).compareTo(Version.parse("2.0.0-beta.0")) == -1;
    }

    public String getAppiumVersion() throws IOException {
        if (StringUtils.isBlank(appiumVersion)) {
            readVersionFromFile();
        }
        return appiumVersion;
    }

    public String getAppiumVersionOrDefault() {
        try {
            return getAppiumVersion();
        } catch (IOException e) {
            return StringUtils.EMPTY;
        }
    }

    private static void readVersionFromFile() throws IOException {
        File packageJsonFile = new File(RunConfiguration.getAppiumDirectory(), PACKAGE_JSON_FILE_NAME);
        if (packageJsonFile != null && packageJsonFile.isFile()) {
            JsonObject jsonObj = (JsonObject) JsonParser.parseReader(new FileReader(packageJsonFile.getAbsoluteFile()));
            if (jsonObj.get(VERSION_ELEMENT) != null
                    && StringUtils.isNotBlank(jsonObj.get(VERSION_ELEMENT).getAsString())) {
                appiumVersion = jsonObj.get(VERSION_ELEMENT).getAsString();
            } else {
                throw new IOException(CoreAppiumMessageConstants.MSG_CANNOT_DETECT_APPIUM_VERSION);
            }
        } else {
            throw new IOException(CoreAppiumMessageConstants.MSG_FILE_NOT_FOUND);
        }
    }

    public static String readVersionFromFile(String appiumDir) {
        try {
            File packageJsonFile = new File(appiumDir, PACKAGE_JSON_FILE_NAME);
            JsonObject jsonObj = (JsonObject) JsonParser.parseReader(new FileReader(packageJsonFile.getAbsoluteFile()));
            return jsonObj.get(VERSION_ELEMENT).getAsString();
        } catch (Exception e) {
            return StringUtils.EMPTY;
        }
    }
}
