package com.kms.katalon.core.webui.driver;

import java.io.IOException;
import java.net.ConnectException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Map;

import org.openqa.selenium.Capabilities;
import org.openqa.selenium.MutableCapabilities;
import org.openqa.selenium.remote.CommandExecutor;
import org.openqa.selenium.remote.DriverCommand;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.remote.Response;

import com.kms.katalon.core.webui.util.WebDriverUtil;
import com.kms.katalon.selenium.driver.IExistingRemoteWebDriver;

public class ExistingRemoteWebDriver extends RemoteWebDriver implements IExistingRemoteWebDriver {

    private static final int REMOTE_BROWSER_CONNECT_TIMEOUT = 60000;
    
    private String oldSessionId;

    public ExistingRemoteWebDriver(URL remoteAddress, String oldSessionId, String webSocketUrl) throws ConnectException, MalformedURLException {
    	super(WebDriverUtil.createCommandExecutorWithRunningSession(remoteAddress, oldSessionId, webSocketUrl), new MutableCapabilities());
    	
        waitForRemoteBrowserReady(remoteAddress);
        setSessionId(oldSessionId);
        this.oldSessionId = oldSessionId;
        startSession(new MutableCapabilities());
    }
    
    public ExistingRemoteWebDriver(String oldSessionId, CommandExecutor executor, Capabilities desiredCapabilities) {
        super(executor, desiredCapabilities);
        this.oldSessionId = oldSessionId;
    }
    
    @Override
    protected void startSession(Capabilities desiredCapabilities) {
        if (this.oldSessionId == null) {
            return;
        }
        super.startSession(desiredCapabilities);
    }
    
    @Override
    public Response createResponseForNewSession(String oldSessionId) {
        this.oldSessionId = oldSessionId;
        return IExistingRemoteWebDriver.super.createResponseForNewSession(oldSessionId);
    }

    @Override
    protected Response execute(String driverCommand, Map<String, ?> parameters) {
        
        if (DriverCommand.NEW_SESSION.equals(driverCommand)) {
            return createResponseForNewSession(oldSessionId);
        }
        
        return super.execute(driverCommand, parameters);
    }

    private static void waitForRemoteBrowserReady(URL url) throws ConnectException {
        long waitUntil = System.currentTimeMillis() + REMOTE_BROWSER_CONNECT_TIMEOUT;
        boolean connectable = false;
        while (!connectable) {
            try {
                url.openConnection().connect();
                connectable = true;
            } catch (IOException e) {
                // Cannot connect yet.
            }

            if (waitUntil < System.currentTimeMillis()) {
                // This exception is meant for devs to see, not user so no need to externalize string
                throw new ConnectException(
                        String.format("Unable to connect to browser on host %s and port %s after %s seconds.", //$NON-NLS-1$
                                url.getHost(), url.getPort(), REMOTE_BROWSER_CONNECT_TIMEOUT));
            }

            try {
                Thread.sleep(100);
            } catch (InterruptedException ignored) {}
        }
    }
}
