package com.kms.katalon.core.webui.driver.smart;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.openqa.selenium.support.events.EventFiringDecorator;

import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.webui.driver.KatalonSmartEventListener;

public class SmartDriverUtil {
    protected static final KeywordLogger logger = KeywordLogger.getInstance(SmartDriverUtil.class);

    public static WebDriver createSmartDriver(WebDriver driver) {
        try {
            var listener = new KatalonSmartEventListener(driver);
            WebDriver decorated;

            if (driver instanceof RemoteWebDriver remoteWebDriver) {
                var decorator = new EventFiringDecorator<>(RemoteWebDriver.class, listener);
                decorated = decorator.decorate(remoteWebDriver);
            } else {
                var decorator = new EventFiringDecorator<>(listener);
                decorated = decorator.decorate(driver);
            }

            return decorated;
        } catch (Exception e) {
            logger.logInfo(e.getMessage());
        }

        return driver;
    }
}
