package com.kms.katalon.core.webui.keyword.builtin

import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain

import groovy.transform.CompileStatic

@Action(value = "switchToDefaultContent")
public class SwitchToDefaultContentKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        FailureHandling flowControl = (FailureHandling)(params.length > 0 && params[0] instanceof FailureHandling ? params[0] : RunConfiguration.getDefaultFailureHandling())
        switchToDefaultContent(flowControl)
    }

    @CompileStatic
    public void switchToDefaultContent(FailureHandling flowControl) throws StepFailedException {
        WebUIKeywordMain.runKeyword({ WebUiCommonHelper.switchToDefaultContent() }, flowControl, RunConfiguration.getTakeScreenshotOption(), StringConstants.KW_MSG_CANNOT_SWITCH_TO_DEFAULT_CONTENT)
    }
}
