package com.kms.katalon.core.webui.keyword.builtin

import java.text.MessageFormat
import java.time.Duration
import java.util.concurrent.TimeUnit

import org.openqa.selenium.By
import org.openqa.selenium.NoSuchElementException
import org.openqa.selenium.TimeoutException
import org.openqa.selenium.WebDriver
import org.openqa.selenium.WebElement
import org.openqa.selenium.support.ui.FluentWait

import com.google.common.base.Function
import com.kms.katalon.core.annotation.internal.Action
import com.kms.katalon.core.configuration.RunConfiguration
import com.kms.katalon.core.exception.StepFailedException
import com.kms.katalon.core.keyword.internal.KeywordExecutor
import com.kms.katalon.core.keyword.internal.SupportLevel
import com.kms.katalon.core.model.FailureHandling
import com.kms.katalon.core.testobject.SelectorMethod
import com.kms.katalon.core.testobject.TestObject
import com.kms.katalon.core.webui.common.WebUiCommonHelper
import com.kms.katalon.core.webui.constants.StringConstants
import com.kms.katalon.core.webui.driver.DriverFactory
import com.kms.katalon.core.webui.exception.WebElementNotFoundException
import com.kms.katalon.core.webui.keyword.internal.WebUIAbstractKeyword
import com.kms.katalon.core.webui.keyword.internal.WebUIKeywordMain
import com.kms.katalon.core.webui.model.FindElementParams
import com.kms.katalon.core.webui.model.WebUiElementFinder

import groovy.transform.CompileStatic

@Action(value = "waitForElementNotPresent")
public class WaitForElementNotPresentKeyword extends WebUIAbstractKeyword {

    @CompileStatic
    @Override
    public SupportLevel getSupportLevel(Object ...params) {
        return super.getSupportLevel(params)
    }

    @CompileStatic
    @Override
    public Object execute(Object ...params) {
        TestObject to = getTestObject(params[0])
        int timeOut = (int) params[1]
        FailureHandling flowControl = (FailureHandling)(params.length > 2 && params[2] instanceof FailureHandling ? params[2] : RunConfiguration.getDefaultFailureHandling())
        return waitForElementNotPresent(to, timeOut, flowControl)
    }

    public boolean waitForElementNotPresent(TestObject to, int timeOut, FailureHandling flowControl) throws StepFailedException {
        WebDriver driver = DriverFactory.getWebDriver();
        timeOut = WebUiCommonHelper.checkTimeout(timeOut)
        long timeoutInMillis = TimeUnit.SECONDS.toMillis(timeOut)
        return WebUIKeywordMain.runKeywordUntilTimeout({retryContext ->
            boolean isSwitchIntoFrame = false
            try {
                WebUiCommonHelper.checkTestObjectParameter(to)
                isSwitchIntoFrame = WebUiCommonHelper.switchToParentFrame(driver, to, timeOut)
				boolean elementNotFound = false
                final By locator = WebUiCommonHelper.buildLocator(to);
                String locatorValue = locator.toString();
                if (to.getSelectorMethod() == SelectorMethod.SMART_LOCATOR) {
                    if (WebUiCommonHelper.ableExecuteWithSmartLocator()) {
                        locatorValue = to.getSmartSelectorCollection().get(SelectorMethod.SMART_LOCATOR);
                    } else {
                        locatorValue = to.getSmartSelectorCollection().get(SelectorMethod.XPATH);
                    }
                }
				try {
					if (locator != null) {
						logger.logDebug(MessageFormat.format(StringConstants.KW_LOG_INFO_FINDING_WEB_ELEMENT_W_ID, to.getObjectId(), locatorValue, timeOut))
						elementNotFound = new FluentWait<WebDriver>(driver)
								.pollingEvery(Duration.ofMillis(500))
								.withTimeout(Duration.ofSeconds(timeOut))
								.until(new Function<WebDriver, Boolean>() {
									@Override
									public Boolean apply(WebDriver webDriver) {
										try {
											if (to.isParentObjectShadowRoot() || to.getSelectorMethod() == SelectorMethod.SMART_LOCATOR) {
                                                FindElementParams findElementParameters = new FindElementParams(to, webDriver)
												List<WebElement> elementList = findWebElementWithoutRetry(webDriver, to, timeoutInMillis)
												if (elementList == null || elementList.size() == 0) {
													return true
												}
											} else {
												webDriver.findElement(locator)
												return false
											}
										} catch (NoSuchElementException | WebElementNotFoundException e) {
											return true
										}
									}
								})
					} else {
						throw new IllegalArgumentException(MessageFormat.format(StringConstants.KW_EXC_WEB_ELEMENT_W_ID_DOES_NOT_HAVE_SATISFY_PROP, to.getObjectId()))
					}
				} catch (TimeoutException e) {
					// timeOut, do nothing
				}
                if (elementNotFound) {
                    logger.logPassed(MessageFormat.format(StringConstants.KW_LOG_PASSED_WEB_ELEMT_W_ID_IS_NOT_PRESENT_AFTER, to.getObjectId(), locatorValue, timeOut))
                    return true
                } else {
                    logger.logWarning(MessageFormat.format(StringConstants.KW_MSG_WEB_ELEMT_W_ID_IS_NOT_PRESENT_AFTER, to.getObjectId(), locatorValue, timeOut))
                    return false
                }
            } finally {
                if (isSwitchIntoFrame) {
                    WebUiCommonHelper.switchToDefaultContent(driver)
                }
            }
        }, flowControl, RunConfiguration.getTakeScreenshotOption(), (to != null) ? MessageFormat.format(StringConstants.KW_MSG_CANNOT_WAIT_OBJ_X_TO_BE_NOT_PRESENT, to.getObjectId())
        : StringConstants.KW_MSG_CANNOT_WAIT_FOR_OBJ_TO_BE_NOT_PRESENT, timeOut)
    }
}
