/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.composer.folder.constants.StringConstants;
import com.kms.katalon.composer.folder.dialogs.NewFolderDialog;
import com.kms.katalon.composer.folder.dialogs.NewRootFolderDialog;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.controller.exception.ControllerException;
import com.kms.katalon.entity.dal.exception.FilePathTooLongException;
import com.kms.katalon.entity.file.FileEntity;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.tracking.service.Trackings;
import jakarta.inject.Inject;
import jakarta.inject.Named;
import org.eclipse.e4.core.di.annotations.CanExecute;
import org.eclipse.e4.core.di.annotations.Execute;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.e4.ui.workbench.modeling.ESelectionService;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class NewFolderHandler {
    @Inject
    private IEventBroker eventBroker;
    @Inject
    private ESelectionService selectionService;

    @CanExecute
    public static boolean canExecute() {
        return ProjectController.getInstance().getCurrentProject() != null;
    }

    @Execute
    public void execute(@Named(value="activeShell") Shell parentShell) {
        try {
            Object[] selectedObjects = (Object[])this.selectionService.getSelection("com.kms.katalon.composer.part.explorer");
            this.createNewFolderEntity(parentShell, selectedObjects, this.eventBroker);
        }
        catch (Exception e) {
            LoggerSingleton.logError((Throwable)e);
            String errorMessage = "";
            errorMessage = e instanceof FilePathTooLongException ? e.getMessage() : StringConstants.HAND_ERROR_MSG_UNABLE_TO_CREATE_FOLDER;
            MessageDialog.openError((Shell)parentShell, (String)StringConstants.ERROR_TITLE, (String)errorMessage);
        }
    }

    public FolderTreeEntity createNewFolderEntity(Shell parentShell, Object[] selectedObjects, IEventBroker eventBroker) throws Exception {
        if (!this.isFirstSelectedObjectValid(selectedObjects)) {
            return this.newFolderAtRoot(parentShell);
        }
        FolderEntity parentFolder = null;
        ITreeEntity parentTreeEntity = (ITreeEntity)selectedObjects[0];
        Object selectedEntity = parentTreeEntity.getObject();
        if (!(selectedEntity instanceof FileEntity)) {
            return null;
        }
        if (!parentTreeEntity.hasChildren()) {
            parentFolder = ((FileEntity)selectedEntity).getParentFolder();
            parentTreeEntity = parentTreeEntity.getParent();
            if (parentFolder == null) {
                return this.newFolderAtRoot(parentShell);
            }
        }
        if (parentFolder == null) {
            parentFolder = (FolderEntity)selectedEntity;
        }
        String newDefaultName = StringConstants.HAND_NEW_FOLDER;
        String suggestedName = FolderController.getInstance().getAvailableFolderName(parentFolder, newDefaultName);
        NewFolderDialog dialog = new NewFolderDialog(parentShell, parentFolder);
        dialog.setName(suggestedName);
        if (dialog.open() != 0) {
            return null;
        }
        FolderEntity newEntity = FolderController.getInstance().addNewFolder(parentFolder, dialog.getName());
        if (newEntity == null) {
            return null;
        }
        FolderTreeEntity newFolderTreeEntity = new FolderTreeEntity(newEntity, parentTreeEntity);
        eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)parentTreeEntity);
        eventBroker.send("EXPLORER/SET_SELECTED_ITEM", (Object)newFolderTreeEntity);
        Trackings.trackCreatingObject((String)"folder", (Object[])new Object[0]);
        return newFolderTreeEntity;
    }

    private boolean isFirstSelectedObjectValid(Object[] selectedObjects) {
        return selectedObjects != null && selectedObjects.length > 0 && selectedObjects[0] instanceof ITreeEntity;
    }

    private FolderTreeEntity newFolderAtRoot(Shell parentShell) throws ControllerException, FilePathTooLongException {
        ProjectEntity project = ProjectController.getInstance().getCurrentProject();
        NewRootFolderDialog dialog = new NewRootFolderDialog(parentShell);
        if (dialog.open() == 0) {
            String newFolderName = dialog.getNewFolderName();
            FolderEntity newFolder = FolderController.getInstance().addNewRootFolder(project, newFolderName);
            FolderTreeEntity newFolderTreeEntity = new FolderTreeEntity(newFolder, null);
            this.eventBroker.send("EXPLORER/ADD_AND_SELECT_ITEM", (Object)newFolderTreeEntity);
            return newFolderTreeEntity;
        }
        return null;
    }
}

