/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.composer.folder.handlers;

import com.kms.katalon.composer.components.impl.tree.FolderTreeEntity;
import com.kms.katalon.composer.components.impl.tree.KeywordTreeEntity;
import com.kms.katalon.composer.components.impl.tree.PackageTreeEntity;
import com.kms.katalon.composer.components.log.LoggerSingleton;
import com.kms.katalon.composer.components.tree.ITreeEntity;
import com.kms.katalon.controller.FolderController;
import com.kms.katalon.controller.KeywordController;
import com.kms.katalon.controller.ProjectController;
import com.kms.katalon.entity.folder.FolderEntity;
import com.kms.katalon.entity.project.ProjectEntity;
import com.kms.katalon.groovy.util.GroovyRefreshUtil;
import com.kms.katalon.groovy.util.GroovyUtil;
import jakarta.annotation.PostConstruct;
import jakarta.inject.Inject;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventHandler;

public class RefreshFolderHandler {
    @Inject
    private IEventBroker eventBroker;

    @PostConstruct
    private void registerEventHandler() {
        this.eventBroker.subscribe("EXPLORER/REFRESH_SELECTED_ITEM", new EventHandler(){

            public void handleEvent(Event event) {
                if (ProjectController.getInstance().getCurrentProject() == null) {
                    return;
                }
                try {
                    Object selectedObject = event.getProperty("org.eclipse.e4.data");
                    if (selectedObject != null && selectedObject instanceof FolderTreeEntity) {
                        RefreshFolderHandler.this.execute((FolderTreeEntity)selectedObject, false);
                    }
                }
                catch (Exception e) {
                    LoggerSingleton.getInstance().getLogger().error((Throwable)e);
                }
            }
        });
    }

    private void execute(FolderTreeEntity folderTreeEntity, boolean isRecursive) throws Exception {
        if (!isRecursive) {
            this.eventBroker.send("EXPLORER/REFRESH_TREE_ENTITY", (Object)folderTreeEntity);
        }
        if (folderTreeEntity.getObject() != null && folderTreeEntity.getObject() instanceof FolderEntity) {
            FolderEntity folderEntity = folderTreeEntity.getObject();
            if (!isRecursive) {
                RefreshingFolderJob refreshingJob = new RefreshingFolderJob(folderEntity);
                refreshingJob.schedule();
            }
            if (FolderController.getInstance().getFolder(folderEntity.getId()) != null) {
                Object[] objectArray = folderTreeEntity.getChildren();
                int n = objectArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Object treeEntityObject = objectArray[n2];
                    ITreeEntity childTreeEntity = (ITreeEntity)treeEntityObject;
                    if (!(childTreeEntity.getObject() == null || childTreeEntity instanceof KeywordTreeEntity && childTreeEntity instanceof PackageTreeEntity)) {
                        if (childTreeEntity instanceof FolderTreeEntity) {
                            this.execute((FolderTreeEntity)childTreeEntity, true);
                        } else {
                            this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)childTreeEntity);
                        }
                    }
                    ++n2;
                }
            } else {
                this.eventBroker.post("EXPLORER/REFRESH_SELECTED_ITEM", (Object)folderTreeEntity.getParent());
            }
        } else if (folderTreeEntity.getParent() != null) {
            this.eventBroker.send("EXPLORER/REFRESH_SELECTED_ITEM", (Object)folderTreeEntity.getParent());
        }
    }

    private class RefreshingFolderJob
    extends Job {
        private FolderEntity folderEntity;

        public RefreshingFolderJob(FolderEntity folderEntity) {
            super("Refresh folder");
            this.folderEntity = folderEntity;
            this.setUser(true);
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                monitor.beginTask("Refreshing folder: " + this.folderEntity.getIdForDisplay() + "...", 2);
                ProjectEntity projectEntity = this.folderEntity.getProject();
                GroovyRefreshUtil.refreshFolder((String)this.folderEntity.getRelativePath(), (ProjectEntity)this.folderEntity.getProject(), (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                if (this.folderEntity.getFolderType() == FolderEntity.FolderType.TESTCASE) {
                    this.folderEntity.setChildrenEntities(FolderController.getInstance().getChildren(this.folderEntity));
                    GroovyUtil.refreshInfiniteScriptTestCaseClasspath((ProjectEntity)projectEntity, (FolderEntity)this.folderEntity, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else if (this.folderEntity.getFolderType() == FolderEntity.FolderType.KEYWORD) {
                    KeywordController.getInstance().parseAllCustomKeywords(projectEntity, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                } else {
                    this.folderEntity.setChildrenEntities(FolderController.getInstance().getChildren(this.folderEntity));
                    monitor.worked(1);
                }
                return Status.OK_STATUS;
            }
            catch (Exception exception) {
                return Status.CANCEL_STATUS;
            }
        }
    }
}

