/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.SimpleTimeZone;

public final class Dates {
    protected final SimpleDateFormat urlDateFormat = new SimpleDateFormat("yyyyMMdd");
    protected final SimpleDateFormat iso8601DateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected final SimpleDateFormat iso8601DateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSSZ");
    protected final SimpleDateFormat alternateIso8601DateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
    protected final SimpleDateFormat alternateIso8601DateTimeFormatWithoutZ = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected final SimpleDateFormat rfc822DateFormat = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss Z", Locale.US);

    private Dates() {
        this.iso8601DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.iso8601DateTimeFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.alternateIso8601DateTimeFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.alternateIso8601DateTimeFormatWithoutZ.setTimeZone(new SimpleTimeZone(0, "GMT"));
        this.rfc822DateFormat.setTimeZone(new SimpleTimeZone(0, "GMT"));
    }

    public static Dates getInstance() {
        return new Dates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseIso8601Date(String source) throws ParseException {
        if (source == null || "".equals(source)) {
            return null;
        }
        int tzPos = source.indexOf("+");
        if (tzPos > 0 && source.charAt(tzPos + 3) == ':' && source.length() > tzPos + 4) {
            source = source.substring(0, tzPos + 3) + source.substring(tzPos + 4);
        }
        try {
            SimpleDateFormat simpleDateFormat = this.iso8601DateTimeFormat;
            synchronized (simpleDateFormat) {
                return this.iso8601DateTimeFormat.parse(source);
            }
        }
        catch (ParseException ex) {
            try {
                SimpleDateFormat simpleDateFormat = this.alternateIso8601DateTimeFormat;
                synchronized (simpleDateFormat) {
                    return this.alternateIso8601DateTimeFormat.parse(source);
                }
            }
            catch (ParseException pex) {
                try {
                    SimpleDateFormat simpleDateFormat = this.alternateIso8601DateTimeFormatWithoutZ;
                    synchronized (simpleDateFormat) {
                        return this.alternateIso8601DateTimeFormatWithoutZ.parse(source);
                    }
                }
                catch (ParseException ppex) {
                    SimpleDateFormat simpleDateFormat = this.iso8601DateFormat;
                    synchronized (simpleDateFormat) {
                        return this.iso8601DateFormat.parse(source);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Date parseRfc822Date(String source) throws ParseException {
        SimpleDateFormat simpleDateFormat = this.rfc822DateFormat;
        synchronized (simpleDateFormat) {
            return this.rfc822DateFormat.parse(source);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatAlternateIso8601Date(Date date) {
        SimpleDateFormat simpleDateFormat = this.alternateIso8601DateTimeFormat;
        synchronized (simpleDateFormat) {
            return this.alternateIso8601DateTimeFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatIso8601DateTime(Date date) {
        SimpleDateFormat simpleDateFormat = this.iso8601DateTimeFormat;
        synchronized (simpleDateFormat) {
            return this.iso8601DateTimeFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatIso8601Date(Date date) {
        SimpleDateFormat simpleDateFormat = this.iso8601DateFormat;
        synchronized (simpleDateFormat) {
            return this.iso8601DateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formaturlDate(Date date) {
        SimpleDateFormat simpleDateFormat = this.urlDateFormat;
        synchronized (simpleDateFormat) {
            return this.urlDateFormat.format(date);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String formatRfc822Date(Date date) {
        SimpleDateFormat simpleDateFormat = this.rfc822DateFormat;
        synchronized (simpleDateFormat) {
            return this.rfc822DateFormat.format(date);
        }
    }
}

