/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util;

import java.net.URI;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.google.base.Strings;
import org.qas.api.net.UriEncoder;

public final class Https {
    public static final String HEADER_ELEMENT_FORMAT = "%s=\"%s\"";
    public static final String QUERY_STRING_ELEMENT_FORMAT = "%s=%s";

    private Https() {
        throw new AssertionError((Object)"The Https utilities class must not be instantiated!");
    }

    public static boolean isUsingNonDefaultPort(URI uri) {
        String scheme = uri.getScheme().toLowerCase();
        int port = uri.getPort();
        if (port <= 0) {
            return false;
        }
        if (scheme.equals("http") && port == 80) {
            return false;
        }
        return !scheme.equals("https") || port != 443;
    }

    public static String pathEncode(String resourcePath) {
        return UriEncoder.encode(resourcePath).replace("%2F", "/");
    }

    public static boolean usePayloadForQueryParameters(Request request) {
        return (HttpMethod.POST.equals((Object)request.getHttpMethod()) || HttpMethod.PUT.equals((Object)request.getHttpMethod())) && request.getContent() == null;
    }

    public static String toSafeString(Object source) {
        return source == null ? null : source.toString();
    }

    public static String percentEncode(Iterator<?> iterator) {
        if (iterator == null || !iterator.hasNext()) {
            return "";
        }
        StringBuilder encode = new StringBuilder();
        encode.append(UriEncoder.encode(Strings.nullToEmpty(Https.toSafeString(iterator.next()))));
        while (iterator.hasNext()) {
            encode.append('&').append(Strings.nullToEmpty(UriEncoder.encode(Https.toSafeString(iterator.next()))));
        }
        return encode.toString();
    }

    public static String toQueryString(Map<String, String> parameters, Charset encoding) {
        if (parameters == null || parameters.isEmpty()) {
            return null;
        }
        StringBuilder queryStringBuilder = new StringBuilder();
        Iterator<Map.Entry<String, String>> it = parameters.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<String, String> entry = it.next();
            queryStringBuilder.append(UriEncoder.encode(entry.getKey(), encoding)).append("=");
            if (!Strings.isNullOrEmpty(entry.getValue())) {
                queryStringBuilder.append(UriEncoder.encode(entry.getValue(), encoding));
            }
            if (!it.hasNext()) continue;
            queryStringBuilder.append("&");
        }
        return queryStringBuilder.toString();
    }

    private static boolean isOauthParam(String name) {
        return name != null && name.startsWith("oauth_");
    }

    public static String toHeaderElement(String name, String value) {
        if (Https.isOauthParam(name)) {
            return Https.format(HEADER_ELEMENT_FORMAT, UriEncoder.encode(Strings.nullToEmpty(name)), UriEncoder.encode(Strings.nullToEmpty(value)));
        }
        return Https.format(HEADER_ELEMENT_FORMAT, UriEncoder.encode(Strings.nullToEmpty(name)), Https.toSafeString(value));
    }

    public static String toQueryElement(String name, String value) {
        return Https.format(QUERY_STRING_ELEMENT_FORMAT, UriEncoder.encode(Strings.nullToEmpty(name)), UriEncoder.encode(Strings.nullToEmpty(value)));
    }

    public static String format(String template, Object ... args) {
        int placeholderStart;
        StringBuilder builder = new StringBuilder(template.length() + 16 * args.length);
        int templateStart = 0;
        int i = 0;
        while (i < args.length && (placeholderStart = template.indexOf("%s", templateStart)) != -1) {
            builder.append(template.substring(templateStart, placeholderStart));
            builder.append(args[i++]);
            templateStart = placeholderStart + 2;
        }
        builder.append(template.substring(templateStart));
        if (i < args.length) {
            builder.append(" [");
            builder.append(args[i++]);
            while (i < args.length) {
                builder.append(", ");
                builder.append(args[i++]);
            }
            builder.append("]");
        }
        return builder.toString();
    }
}

