/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.internal.util.key.support;

import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.qas.api.internal.util.Encoders;
import org.qas.api.internal.util.key.UniqueKey;
import org.qas.api.internal.util.key.UniqueKeyImportException;

final class MachineKey
extends UniqueKey {
    private final int time;
    private final int machine;
    private final int inc;

    MachineKey(int time, int machine, int inc) {
        this.time = time;
        this.machine = machine;
        this.inc = inc;
    }

    @Override
    public byte[] bytes() {
        byte[] result = new byte[12];
        ByteBuffer buffer = ByteBuffer.wrap(result);
        buffer.order(ByteOrder.BIG_ENDIAN);
        buffer.putInt(this.time);
        buffer.putInt(this.machine);
        buffer.putInt(this.inc);
        return result;
    }

    @Override
    public int size() {
        return 12;
    }

    @Override
    public int compareTo(UniqueKey uniqueKey) {
        int result;
        if (uniqueKey == null) {
            return -1;
        }
        int n = uniqueKey.size() > 12 ? -1 : (result = uniqueKey.size() < 12 ? 1 : 0);
        if (result != 0) {
            return result;
        }
        byte[] obytes = uniqueKey.bytes();
        byte[] bytes = this.bytes();
        for (int index = 0; index < 12; ++index) {
            int first = 255;
            int second = 255;
            int diff = (first &= bytes[index]) - (second &= obytes[index]);
            if (diff == 0) continue;
            return diff;
        }
        return 0;
    }

    public int hashCode() {
        return Arrays.hashCode(new int[]{this.time, this.machine, this.inc});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || !(o instanceof MachineKey)) {
            return false;
        }
        MachineKey that = (MachineKey)o;
        return this.time == that.time && this.machine == that.machine && this.inc == that.inc;
    }

    @Override
    public String toString() {
        return Encoders.bytesToHex(this.bytes());
    }

    static MachineKey from(byte[] source) throws UniqueKeyImportException {
        if (source == null || source.length != 12) {
            throw new UniqueKeyImportException("The key is invalid. It must not be null, and contains exactly 12 bytes.");
        }
        ByteBuffer bb = ByteBuffer.wrap(source);
        bb.order(ByteOrder.BIG_ENDIAN);
        return new MachineKey(bb.getInt(), bb.getInt(), bb.getInt());
    }
}

