/*
 * Decompiled with CFR 0.152.
 */
package org.qas.api.support;

import java.io.InputStream;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.qas.api.ApiServiceRequest;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.google.base.Preconditions;
import org.qas.api.internal.util.google.base.Strings;

public class RequestSupport
implements Request {
    private final String serviceName;
    private final ApiServiceRequest originalRequest;
    private String resourcePath;
    private HttpMethod httpMethod = HttpMethod.POST;
    private URI endpoint;
    private int timeOffset;
    private InputStream content;
    private Map<String, String> parameters = new HashMap<String, String>();
    private Map<String, String> headers = new HashMap<String, String>();

    public RequestSupport(ApiServiceRequest originalRequest, String serviceName) {
        Preconditions.checkNotNull(serviceName, "The service name must not null.");
        this.serviceName = serviceName;
        this.originalRequest = originalRequest;
    }

    @Override
    public String getServiceName() {
        return this.serviceName;
    }

    @Override
    public String getResourcePath() {
        return this.resourcePath;
    }

    @Override
    public void setResourcePath(String resourcePath) {
        this.resourcePath = resourcePath;
    }

    @Override
    public Request withResourcePath(String resourcePath) {
        this.setResourcePath(resourcePath);
        return this;
    }

    @Override
    public HttpMethod getHttpMethod() {
        return this.httpMethod;
    }

    @Override
    public void setHttpMethod(HttpMethod httpMethod) {
        Preconditions.checkNotNull(httpMethod, "The HTTP Method must not be null.");
        this.httpMethod = httpMethod;
    }

    @Override
    public Request withHttpMethod(HttpMethod httpMethod) {
        this.setHttpMethod(httpMethod);
        return this;
    }

    @Override
    public void setEndpoint(URI endpoint) {
        Preconditions.checkNotNull(endpoint);
        this.endpoint = endpoint;
    }

    @Override
    public URI getEndpoint() {
        return this.endpoint;
    }

    @Override
    public Request withEndpoint(URI endpoint) {
        this.setEndpoint(endpoint);
        return this;
    }

    @Override
    public void setTimeOffset(int timeOffset) {
        this.timeOffset = timeOffset;
    }

    @Override
    public int getTimeOffset() {
        return this.timeOffset;
    }

    @Override
    public Request withTimeOffset(int timeOffset) {
        this.setTimeOffset(timeOffset);
        return this;
    }

    @Override
    public void setContent(InputStream content) {
        this.content = content;
    }

    @Override
    public InputStream getContent() {
        return this.content;
    }

    @Override
    public Request withContent(InputStream content) {
        this.setContent(content);
        return this;
    }

    @Override
    public void setHeader(String name, String value) {
        this.headers.put(name, value);
    }

    @Override
    public void setHeaders(Map<String, String> headers) {
        this.headers.clear();
        for (Map.Entry<String, String> entry : headers.entrySet()) {
            this.headers.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Request withHeader(String name, String value) {
        this.setHeader(name, value);
        return this;
    }

    @Override
    public Request withHeaders(Map<String, String> headers) {
        this.setHeaders(headers);
        return this;
    }

    @Override
    public Map<String, String> getHeaders() {
        return Collections.unmodifiableMap(this.headers);
    }

    @Override
    public void addParameter(String name, String value) {
        this.parameters.put(name, value);
    }

    @Override
    public Request withParameter(String name, String value) {
        this.addParameter(name, value);
        return this;
    }

    @Override
    public void setParameters(Map<String, String> parameters) {
        this.parameters.clear();
        for (Map.Entry<String, String> entry : parameters.entrySet()) {
            this.parameters.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public Request withParameters(Map<String, String> parameters) {
        this.setParameters(parameters);
        return this;
    }

    @Override
    public Map<String, String> getParameters() {
        return Collections.unmodifiableMap(this.parameters);
    }

    @Override
    public ApiServiceRequest getOriginalRequest() {
        return this.originalRequest;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder("<request>\n");
        builder.append("\t<service-name value=\"").append(this.serviceName).append("\"/>\n");
        builder.append("\t<http-method value=\"").append(this.httpMethod.name()).append("\"/>\n");
        builder.append("\t<endpoint value=\"").append(this.endpoint.toString()).append("\"/>\n");
        if (!Strings.isNullOrEmpty(this.resourcePath)) {
            builder.append("\t<resource-path value=\"").append(this.resourcePath).append("\"/>\n");
        }
        builder.append("\t<time-offset value=\"").append(this.timeOffset).append("\"/>\n");
        builder.append("\t<headers>").append(this.headers.toString()).append("</headers>\n");
        builder.append("\t<parameters>").append(this.parameters.toString()).append("</parameters>\n");
        builder.append("</request>");
        return builder.toString();
    }
}

