/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.auth;

import org.qas.api.AuthClientException;
import org.qas.api.Credentials;
import org.qas.api.Request;
import org.qas.api.auth.AbstractSigner;
import org.qas.api.internal.util.Encoders;
import org.qas.qtest.api.auth.BasicQTestCredentials;
import org.qas.qtest.api.auth.QTestCredentials;

public abstract class AbstractQTestSigner
extends AbstractSigner {
    @Override
    public final void sign(Request request, Credentials credentials) {
        if (!(credentials instanceof QTestCredentials)) {
            throw new AuthClientException("The credentials you provider is invalid");
        }
        QTestCredentials sanitizeCredentials = this.sanitizeCredentials((QTestCredentials)credentials);
        this.sign(request, sanitizeCredentials);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected QTestCredentials sanitizeCredentials(QTestCredentials credentials) {
        String token = null;
        QTestCredentials qTestCredentials = credentials;
        synchronized (qTestCredentials) {
            token = credentials.getToken();
        }
        if (token != null) {
            token = token.trim();
        }
        return new BasicQTestCredentials(token);
    }

    protected String getCanonicalizedResourcePath(Request request) {
        String resourcePath = "";
        if (request.getEndpoint().getPath() != null) {
            resourcePath = resourcePath + request.getEndpoint().getPath();
        }
        if (resourcePath.endsWith("/")) {
            resourcePath = resourcePath.substring(0, resourcePath.length() - 1);
        }
        if (request.getResourcePath() != null) {
            if (resourcePath.length() > 0 && !resourcePath.endsWith("/") && !request.getResourcePath().startsWith("/")) {
                resourcePath = resourcePath + "/";
            }
            resourcePath = resourcePath + request.getResourcePath();
        }
        if (!resourcePath.startsWith("/")) {
            resourcePath = "/" + resourcePath;
        }
        if (resourcePath.startsWith("//")) {
            resourcePath = resourcePath.substring(1);
        }
        return resourcePath;
    }

    @Override
    protected final String base64(byte[] source) {
        return Encoders.base64UrlEncodeText(source);
    }

    protected abstract void sign(Request var1, QTestCredentials var2);
}

