/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.auth;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.qas.qtest.api.auth.QTestCredentials;

public class PropertiesQTestCredentials
implements QTestCredentials {
    private final String token;

    public PropertiesQTestCredentials(File file) throws IOException, IllegalArgumentException {
        if (!file.exists()) {
            throw new FileNotFoundException("File doesn't exist:  " + file.getAbsolutePath());
        }
        Properties properties = new Properties();
        properties.load(new FileInputStream(file));
        if (properties.getProperty("token") == null) {
            throw new IllegalArgumentException("The specified properties datadoesn't contain the expected properties 'token'.");
        }
        this.token = properties.getProperty("token");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public PropertiesQTestCredentials(InputStream inputStream) throws IOException {
        Properties properties = new Properties();
        try {
            properties.load(inputStream);
        }
        finally {
            try {
                inputStream.close();
            }
            catch (Exception exception) {}
        }
        if (properties.getProperty("token") == null) {
            throw new IllegalArgumentException("The specified properties datadoesn't contain the expected properties 'token'.");
        }
        this.token = properties.getProperty("token");
    }

    @Override
    public String getToken() {
        return this.token;
    }
}

