/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.internal.model;

public enum DataType {
    Unknown(-1, "Unknown"),
    TextBox(1, "Text box"),
    TextArea(2, "Text area"),
    List(3, "List"),
    Date(4, "Date"),
    UserList(5, "User list"),
    Editor(6, "Editor"),
    Number(7, "Number"),
    Checklist(8, "Check list"),
    DateTime(9, "Date time"),
    Id(11, "Identifier"),
    Url(12, "URL"),
    ColoredList(15, "ColoredList");

    private final int id;
    private final String description;

    private DataType(int id, String description) {
        this.id = id;
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public String getDescription() {
        return this.description;
    }

    public static DataType matches(String dataType) {
        if ("textbox".equals(dataType.toLowerCase())) {
            return TextBox;
        }
        if ("textarea".equals(dataType.toLowerCase())) {
            return TextArea;
        }
        if ("list".equals(dataType.toLowerCase())) {
            return List;
        }
        if ("date".equals(dataType.toLowerCase())) {
            return Date;
        }
        if ("userlist".equals(dataType.toLowerCase())) {
            return UserList;
        }
        if ("editor".equals(dataType.toLowerCase())) {
            return Editor;
        }
        if ("number".equals(dataType.toLowerCase())) {
            return Number;
        }
        if ("checklist".equals(dataType.toLowerCase())) {
            return Checklist;
        }
        if ("datetime".equals(dataType.toLowerCase())) {
            return DateTime;
        }
        if ("id".equals(dataType.toLowerCase())) {
            return Id;
        }
        if ("url".equals(dataType.toLowerCase())) {
            return Url;
        }
        if ("coloredlist".equals(dataType.toLowerCase())) {
            return ColoredList;
        }
        return Unknown;
    }

    public static DataType matches(int dataTypeId) {
        if (dataTypeId == DataType.TextBox.id) {
            return TextBox;
        }
        if (dataTypeId == DataType.TextArea.id) {
            return TextArea;
        }
        if (dataTypeId == DataType.List.id) {
            return List;
        }
        if (dataTypeId == DataType.Date.id) {
            return Date;
        }
        if (dataTypeId == DataType.UserList.id) {
            return UserList;
        }
        if (dataTypeId == DataType.Editor.id) {
            return Editor;
        }
        if (dataTypeId == DataType.Number.id) {
            return Number;
        }
        if (dataTypeId == DataType.Checklist.id) {
            return Checklist;
        }
        if (dataTypeId == DataType.DateTime.id) {
            return DateTime;
        }
        if (dataTypeId == DataType.Id.id) {
            return Id;
        }
        if (dataTypeId == DataType.Url.id) {
            return Url;
        }
        if (dataTypeId == DataType.ColoredList.id) {
            return ColoredList;
        }
        return Unknown;
    }
}

