/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.internal.model;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import org.qas.api.internal.PropertyContainer;
import org.qas.api.internal.util.StringInputStream;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.internal.model.Link;

@JsonInclude(value=JsonInclude.Include.NON_EMPTY)
public abstract class QTestBaseModel<T extends QTestBaseModel<T>>
extends PropertyContainer {
    @JsonProperty(value="links")
    private List<Link> links;
    @JsonProperty(value="web_url")
    private String webUrl;

    public List<Link> getLinks() {
        if (this.links == null) {
            return Collections.emptyList();
        }
        return this.links;
    }

    public T setLinks(List<Link> links) {
        this.links = links;
        return (T)this;
    }

    public QTestBaseModel<T> withLinks(List<Link> links) {
        this.setLinks(links);
        return this;
    }

    public String getWebUrl() {
        return this.webUrl;
    }

    public T setWebUrl(String webUrl) {
        this.webUrl = webUrl;
        return (T)this;
    }

    public QTestBaseModel<T> withWebUrl(String webUrl) {
        this.setWebUrl(webUrl);
        return this;
    }

    protected byte[] getBinaryFromInputStream(InputStream content, boolean markedSupport) throws IOException {
        try {
            int length;
            content = this.validateInputStream(content, markedSupport);
            if (markedSupport) {
                content.mark(-1);
            }
            ByteArrayOutputStream output = new ByteArrayOutputStream(1024);
            byte[] buffer = new byte[8096];
            while ((length = content.read(buffer)) > -1) {
                output.write(buffer, 0, length);
            }
            output.close();
            if (markedSupport) {
                content.reset();
            }
            return output.toByteArray();
        }
        catch (Exception ex) {
            throw new IOException("Unable to read input stream: " + ex.getMessage(), ex);
        }
    }

    protected InputStream validateInputStream(InputStream content, boolean markSupported) throws IOException {
        try {
            if (content == null) {
                return new ByteArrayInputStream(new byte[0]);
            }
            if (content instanceof StringInputStream) {
                return content;
            }
            if (markSupported && !content.markSupported()) {
                throw new IOException("Unable to read input stream. Not support mark/reset.");
            }
            return content;
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, IOException.class);
            throw new IOException("Unable to read input stream: " + ex.getMessage(), ex);
        }
    }
}

