/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.internal.model.transform;

import org.qas.api.ApiServiceRequest;
import org.qas.api.AuthClientException;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.UniqueKeys;
import org.qas.api.support.RequestSupport;
import org.qas.api.transform.Marshaller;
import org.qas.qtest.api.internal.util.ApiPreconditions;

public abstract class AbstractQTestApiRequestMarshaller<T extends ApiServiceRequest>
implements Marshaller<Request, T> {
    protected static void validateProjectId(Long projectId) throws AuthClientException {
        AbstractQTestApiRequestMarshaller.validateId(projectId, "Invalid project id passed to marshall(...)");
    }

    protected static void validateId(Long id, String message) throws AuthClientException {
        ApiPreconditions.checkArgument(id != null && id > 0L, message);
    }

    protected Request createJsonRequest(T requestType, String serviceName, String requestAction, HttpMethod requestMethod) {
        RequestSupport request = new RequestSupport((ApiServiceRequest)requestType, serviceName);
        request.setHeader("x-qtest-action", requestAction);
        request.setHeader("x-qtest-api-version", "V3");
        request.setHeader("x-qtest-nonce", UniqueKeys.generateNonce());
        request.setHeader("x-qtest-service-name", request.getServiceName());
        request.setHeader("Content-Type", "application/json");
        request.setHeader("Accept", "application/json");
        request.setHttpMethod(requestMethod);
        return request;
    }

    protected String getApiV3BasePath() {
        return "/api/v3";
    }

    protected String createApiBasePathWithProject(Long projectId) {
        return String.format("%s/projects/%s", this.getApiV3BasePath(), projectId);
    }
}

