/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.defect;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.internal.model.CreateObjectCommentRequest;
import org.qas.qtest.api.internal.model.transform.CreateObjectCommentRequestMarshaller;
import org.qas.qtest.api.services.defect.DefectService;
import org.qas.qtest.api.services.defect.model.CreateDefectRequest;
import org.qas.qtest.api.services.defect.model.Defect;
import org.qas.qtest.api.services.defect.model.transform.CreateDefectRequestMarshaller;
import org.qas.qtest.api.services.defect.model.transform.DefectJsonUnmarshaller;

public class DefectServiceClient
extends QTestApiWebServiceClient<DefectServiceClient>
implements DefectService {
    public DefectServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public DefectServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public DefectServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public DefectServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public DefectServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public DefectServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public Defect createDefect(CreateDefectRequest createDefectRequest) throws AuthServiceException {
        try {
            Object request = new CreateDefectRequestMarshaller().marshall(createDefectRequest);
            return this.invoke((Request)request, DefectJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during creating request", ex);
        }
    }

    @Override
    public Defect addComment(CreateObjectCommentRequest createObjectCommentRequest) throws AuthServiceException {
        try {
            Object request = new CreateObjectCommentRequestMarshaller("DefectService").marshall(createObjectCommentRequest);
            return this.invoke((Request)request, DefectJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("Unknown error occurs during creating defect comment", ex);
        }
    }
}

