/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.execution.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.execution.model.UpdateTestRunRequest;
import org.qas.qtest.api.services.execution.model.transform.AbstractTestRunRequestMarshaller;

public final class UpdateTestRunRequestMarshaller
extends AbstractTestRunRequestMarshaller<UpdateTestRunRequest> {
    @Override
    public Request marshall(UpdateTestRunRequest testRunRequest) throws Exception {
        testRunRequest = ApiPreconditions.notNull(testRunRequest);
        UpdateTestRunRequestMarshaller.validateProjectId(testRunRequest.getProjectId());
        UpdateTestRunRequestMarshaller.validateTestRunId(testRunRequest.getTestRunId());
        ApiPreconditions.notNull(testRunRequest.getTestRun(), "Invalid test-run passed to marshall(...)");
        Request request = this.createJsonRequest(testRunRequest, "UpdateTestRun", HttpMethod.PUT);
        StringBuilder pathBuilder = this.createApiPathBuilder(testRunRequest.getProjectId());
        pathBuilder.append("/").append(testRunRequest.getTestRunId());
        request.setResourcePath(pathBuilder.toString());
        request.setContent(new StringInputStream(JsonMapper.toJson(testRunRequest.getTestRun())));
        return request;
    }
}

