/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.plan;

import org.qas.api.AuthClientException;
import org.qas.api.AuthServiceException;
import org.qas.api.ClientConfiguration;
import org.qas.api.Request;
import org.qas.api.internal.util.google.base.Throwables;
import org.qas.qtest.api.auth.DefaultQTestCredentialsProviderChain;
import org.qas.qtest.api.auth.QTestCredentials;
import org.qas.qtest.api.auth.QTestCredentialsProvider;
import org.qas.qtest.api.auth.StaticQTestCredentialsProvider;
import org.qas.qtest.api.internal.QTestApiWebServiceClient;
import org.qas.qtest.api.services.plan.TestPlanService;
import org.qas.qtest.api.services.plan.model.Build;
import org.qas.qtest.api.services.plan.model.CreateBuildRequest;
import org.qas.qtest.api.services.plan.model.CreateReleaseRequest;
import org.qas.qtest.api.services.plan.model.Release;
import org.qas.qtest.api.services.plan.model.transform.BuildJsonUnmarshaller;
import org.qas.qtest.api.services.plan.model.transform.CreateBuildRequestMarshaller;
import org.qas.qtest.api.services.plan.model.transform.CreateReleaseRequestMarshaller;
import org.qas.qtest.api.services.plan.model.transform.ReleaseJsonUnmarshaller;

public class TestPlanServiceClient
extends QTestApiWebServiceClient<TestPlanServiceClient>
implements TestPlanService {
    public TestPlanServiceClient() {
        this(new DefaultQTestCredentialsProviderChain(), new ClientConfiguration());
    }

    public TestPlanServiceClient(ClientConfiguration clientConfiguration) {
        this(new DefaultQTestCredentialsProviderChain(), clientConfiguration);
    }

    public TestPlanServiceClient(QTestCredentials credentials) {
        this(credentials, new ClientConfiguration());
    }

    public TestPlanServiceClient(QTestCredentials credentials, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = new StaticQTestCredentialsProvider(credentials);
        this.init();
    }

    public TestPlanServiceClient(QTestCredentialsProvider credentialsProvider) {
        this(credentialsProvider, new ClientConfiguration());
    }

    public TestPlanServiceClient(QTestCredentialsProvider credentialsProvider, ClientConfiguration clientConfiguration) {
        super(clientConfiguration);
        this.credentialsProvider = credentialsProvider;
        this.init();
    }

    @Override
    public Build createBuild(CreateBuildRequest createBuildRequest) throws AuthServiceException {
        try {
            Object request = new CreateBuildRequestMarshaller().marshall(createBuildRequest);
            return this.invoke((Request)request, BuildJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during creating build.", ex);
        }
    }

    @Override
    public Release createRelease(CreateReleaseRequest createReleaseRequest) throws AuthServiceException {
        try {
            Object request = new CreateReleaseRequestMarshaller().marshall(createReleaseRequest);
            return this.invoke((Request)request, ReleaseJsonUnmarshaller.getInstance());
        }
        catch (Exception ex) {
            Throwables.propagateIfInstanceOf(ex, AuthClientException.class);
            throw new AuthClientException("An error occurs during creating release.", ex);
        }
    }
}

