/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.MoveModuleRequest;
import org.qas.qtest.api.services.project.model.transform.AbstractModuleRequestMarshaller;

public final class MoveModuleRequestMarshaller
extends AbstractModuleRequestMarshaller<MoveModuleRequest> {
    @Override
    public Request marshall(MoveModuleRequest moduleRequest) throws Exception {
        moduleRequest = ApiPreconditions.notNull(moduleRequest);
        MoveModuleRequestMarshaller.validateProjectId(moduleRequest.getProjectId());
        MoveModuleRequestMarshaller.validateModuleId(moduleRequest.getModuleId());
        ApiPreconditions.checkArgument(moduleRequest.getParentId() == null || moduleRequest.getParentId() > 0L, "Invalid parent identifier passed to marshall(...)");
        Request request = this.createJsonRequest(moduleRequest, "MoveModule", HttpMethod.PUT);
        StringBuilder pathBuilder = this.createApiPathBuilder(moduleRequest.getProjectId());
        pathBuilder.append("/").append(moduleRequest.getModuleId());
        request.setResourcePath(pathBuilder.toString());
        if (moduleRequest.getParentId() != null) {
            request.addParameter("parentId", String.valueOf(moduleRequest.getModuleId()));
        }
        request.setContent(new StringInputStream("{}"));
        return request;
    }
}

