/*
 * Decompiled with CFR 0.152.
 */
package org.qas.qtest.api.services.project.model.transform;

import org.qas.api.JsonMapper;
import org.qas.api.Request;
import org.qas.api.http.HttpMethod;
import org.qas.api.internal.util.StringInputStream;
import org.qas.qtest.api.internal.util.ApiPreconditions;
import org.qas.qtest.api.services.project.model.UpdateModuleRequest;
import org.qas.qtest.api.services.project.model.transform.AbstractModuleRequestMarshaller;

public final class UpdateModuleRequestMarshaller
extends AbstractModuleRequestMarshaller<UpdateModuleRequest> {
    @Override
    public Request marshall(UpdateModuleRequest moduleRequest) throws Exception {
        moduleRequest = ApiPreconditions.notNull(moduleRequest);
        UpdateModuleRequestMarshaller.validateProjectId(moduleRequest.getProjectId());
        ApiPreconditions.notNull(moduleRequest.getModule(), "Invalid module passed to marshall(...)");
        UpdateModuleRequestMarshaller.validateModuleId(moduleRequest.getModule().getId());
        Request request = this.createJsonRequest(moduleRequest, "UpdateModule", HttpMethod.PUT);
        StringBuilder pathBuilder = this.createApiPathBuilder(moduleRequest.getProjectId());
        pathBuilder.append("/").append(moduleRequest.getModule().getId());
        request.setResourcePath(pathBuilder.toString());
        request.setContent(new StringInputStream(JsonMapper.toJson(moduleRequest.getModule())));
        return request;
    }
}

