/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.common.internal;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.kms.katalon.core.configuration.RunConfiguration;
import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.logging.KeywordLogger;
import com.kms.katalon.core.mobile.common.FindElementsResult;
import com.kms.katalon.core.mobile.constants.StringConstants;
import com.kms.katalon.core.mobile.helper.MobileScreenCaptor;
import com.kms.katalon.core.mobile.keyword.internal.MobileDriverFactory;
import com.kms.katalon.core.testobject.BrokenTestObject;
import com.kms.katalon.core.testobject.BrokenTestObjects;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.ObjectRepository;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.util.internal.PathUtil;
import com.kms.katalon.core.webui.util.FileUtil;
import io.appium.java_client.AppiumDriver;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.imageio.ImageIO;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.WebElement;

public class SelfHealingController {
    private static final String SELF_HEALING_PREFIX = "[MOBILE-SELF-HEALING]";
    public static final String REPORT_FOLDER_NAME = "Reports";
    public static final String SELF_HEALING_FOLDER_NAME = "Self-healing";
    public static final String SELF_HEALING_DATA_FILE_NAME = "broken-test-objects-v2.json";
    public static final String SELF_HEALING_FOLDER_PATH = "Reports/Self-healing";
    private static KeywordLogger logger = KeywordLogger.getInstance(SelfHealingController.class);

    public static void setLogger(KeywordLogger logger) {
        SelfHealingController.logger = logger;
    }

    public static void logInfo(String message) {
        logger.logInfo(SelfHealingController.selfHealingPrefixify(message));
    }

    public static void logError(String message) {
        logger.logError(SelfHealingController.selfHealingPrefixify(message));
    }

    public static void logError(String message, Throwable throwable) {
        logger.logError(SelfHealingController.selfHealingPrefixify(message), null, throwable);
    }

    public static void logWarning(String message) {
        logger.logWarning(SelfHealingController.selfHealingPrefixify(message));
    }

    public static void logWarning(String message, Throwable throwable) {
        logger.logWarning(SelfHealingController.selfHealingPrefixify(message), null, throwable);
    }

    private static String selfHealingPrefixify(String message) {
        return "[MOBILE-SELF-HEALING] " + message;
    }

    public static BrokenTestObject registerBrokenTestObject(TestObject testObject, String proposedLocator, LocatorStrategy proposedLocatorStrategy, LocatorStrategy recoveryLocatorStrategy, String pathToScreenshot) {
        String dataFolderPath = SelfHealingController.getSelfHealingFolderPath();
        return SelfHealingController.registerBrokenTestObject(testObject, proposedLocator, proposedLocatorStrategy, recoveryLocatorStrategy, pathToScreenshot, dataFolderPath);
    }

    public static BrokenTestObject registerBrokenTestObject(TestObject testObject, String proposedLocator, LocatorStrategy proposedLocatorStrategy, LocatorStrategy recoveryLocatorStrategy, String pathToScreenshot, String dataFolderPath) {
        String dataFilePath = SelfHealingController.getSelfHealingDataFilePath(dataFolderPath);
        BrokenTestObject brokenTestObject = SelfHealingController.buildBrokenTestObject(testObject, proposedLocator, proposedLocatorStrategy, recoveryLocatorStrategy, pathToScreenshot);
        BrokenTestObjects existingBrokenTestObjects = SelfHealingController.readExistingBrokenTestObjects(dataFilePath);
        if (existingBrokenTestObjects != null) {
            existingBrokenTestObjects.getBrokenTestObjects().add(brokenTestObject);
            SelfHealingController.writeBrokenTestObjects(existingBrokenTestObjects, dataFilePath);
        } else {
            SelfHealingController.logError(dataFilePath + " does not exist or is provided by Self-healing Plugin!");
        }
        return brokenTestObject;
    }

    private static void saveBrokenTestObject(BrokenTestObject brokenTestObject) {
        String dataFilePath = SelfHealingController.getSelfHealingDataFilePath();
        BrokenTestObjects existingBrokenTestObjects = SelfHealingController.readExistingBrokenTestObjects(dataFilePath);
        if (existingBrokenTestObjects != null) {
            Set brokenTestObjects = existingBrokenTestObjects.getBrokenTestObjects();
            if (!brokenTestObjects.contains(brokenTestObject)) {
                brokenTestObjects.add(brokenTestObject);
                SelfHealingController.writeBrokenTestObjects(existingBrokenTestObjects, dataFilePath);
            }
        } else {
            SelfHealingController.logError(dataFilePath + " does not exist or is provided by Self-healing Plugin!");
        }
    }

    private static void writeBrokenTestObjects(BrokenTestObjects brokenTestObjects, String filePath) {
        try {
            SelfHealingController.prepareDataFile(filePath);
            FileWriter writer = new FileWriter(filePath);
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            gson.toJson((Object)brokenTestObjects, (Appendable)writer);
            ((Writer)writer).flush();
            ((Writer)writer).close();
        }
        catch (Exception e) {
            SelfHealingController.logError(e.getMessage(), e);
        }
    }

    public static BrokenTestObjects readExistingBrokenTestObjects(String filePath) {
        try {
            SelfHealingController.prepareDataFile(filePath);
            Gson gson = new Gson();
            JsonReader reader = new JsonReader((Reader)new FileReader(filePath));
            BrokenTestObjects brokenTestObjects = (BrokenTestObjects)gson.fromJson(reader, BrokenTestObjects.class);
            reader.close();
            return brokenTestObjects != null ? brokenTestObjects : new BrokenTestObjects();
        }
        catch (Exception e) {
            SelfHealingController.logError(e.getMessage(), e);
            return null;
        }
    }

    public static File prepareDataFile(String dataFilePath) {
        File autoHealingFile = new File(dataFilePath);
        File selfHealingDirectory = autoHealingFile.getParentFile();
        if (!selfHealingDirectory.exists()) {
            selfHealingDirectory.mkdirs();
            if (!selfHealingDirectory.exists()) {
                SelfHealingController.logError(MessageFormat.format("The folder \"{0}\" does not exist, no file is created.", selfHealingDirectory.getAbsolutePath()));
                return null;
            }
        }
        if (!autoHealingFile.exists()) {
            try {
                if (autoHealingFile.createNewFile()) {
                    BrokenTestObjects emptyBrokenTestObjects = new BrokenTestObjects();
                    FileWriter writer = new FileWriter(autoHealingFile.getAbsolutePath());
                    Gson gson = new GsonBuilder().setPrettyPrinting().create();
                    gson.toJson((Object)emptyBrokenTestObjects, (Appendable)writer);
                    ((Writer)writer).flush();
                    ((Writer)writer).close();
                    return autoHealingFile;
                }
            }
            catch (IOException exception) {
                SelfHealingController.logError(exception.getMessage());
                return null;
            }
        }
        return autoHealingFile;
    }

    private static BrokenTestObject buildBrokenTestObject(TestObject testObject, String proposedLocator, LocatorStrategy proposedLocatorStrategy, LocatorStrategy recoveryLocatorStrategy, String pathToScreenshot) {
        MobileTestObject mobileTestObject = (MobileTestObject)testObject;
        LocatorStrategy brokenLocatorStrategy = ((MobileTestObject)testObject).getLocatorStrategy();
        String brokenLocator = (String)mobileTestObject.getLocatorCollection().get(brokenLocatorStrategy);
        BrokenTestObject brokenTestObject = new BrokenTestObject();
        brokenTestObject.setTestObjectId(testObject.getObjectId());
        brokenTestObject.setApproved(Boolean.valueOf(true));
        brokenTestObject.setBrokenLocator(brokenLocator);
        brokenTestObject.setBrokenLocatorMethod(brokenLocatorStrategy.toString());
        brokenTestObject.setProposedLocator(proposedLocator);
        brokenTestObject.setProposedLocatorMethod(proposedLocatorStrategy.toString());
        brokenTestObject.setRecoveryMethod(recoveryLocatorStrategy.toString());
        brokenTestObject.setPathToScreenshot(pathToScreenshot);
        return brokenTestObject;
    }

    public static Set<BrokenTestObject> findBrokenTestObjects(TestObject testObject) {
        String selfHealingDataFilePath = SelfHealingController.getSelfHealingDataFilePath();
        BrokenTestObjects existingBrokenTestObjects = SelfHealingController.readExistingBrokenTestObjects(selfHealingDataFilePath);
        if (existingBrokenTestObjects != null) {
            Set brokenTestObjects = existingBrokenTestObjects.getBrokenTestObjects();
            return brokenTestObjects.stream().filter(brokenTestObject -> StringUtils.equals((CharSequence)brokenTestObject.getTestObjectId(), (CharSequence)testObject.getObjectId())).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static List<TestObject> findHealedTestObjects(TestObject testObject) {
        Set<BrokenTestObject> brokenTestObjects = SelfHealingController.findBrokenTestObjects(testObject);
        if (brokenTestObjects != null && brokenTestObjects != null && !brokenTestObjects.isEmpty()) {
            return brokenTestObjects.stream().map(brokenTestObject -> SelfHealingController.healTestObject(brokenTestObject)).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    public static TestObject healTestObject(BrokenTestObject brokenTestObject) {
        TestObject testObject = ObjectRepository.findTestObject((String)brokenTestObject.getTestObjectId());
        if (testObject instanceof MobileTestObject) {
            String locator = brokenTestObject.getProposedLocator();
            LocatorStrategy locatorStrategy = LocatorStrategy.valueOf((String)brokenTestObject.getProposedLocatorMethod());
            ((MobileTestObject)testObject).setLocator(locator);
            ((MobileTestObject)testObject).setLocatorStrategy(locatorStrategy);
        }
        return testObject;
    }

    public static String getSelfHealingDataFilePath() {
        return SelfHealingController.getSelfHealingDataFilePath(SelfHealingController.getSelfHealingFolderPath());
    }

    public static String getSelfHealingFolderPath() {
        return Path.of(RunConfiguration.getProjectDir(), REPORT_FOLDER_NAME, SELF_HEALING_FOLDER_NAME).toString();
    }

    public static String getSelfHealingDataFilePath(String folder) {
        return Path.of(folder, SELF_HEALING_DATA_FILE_NAME).toString();
    }

    public static String takeScreenShot(AppiumDriver appiumDriver, WebElement element, String name) {
        String selfHealingFolder = SelfHealingController.getSelfHealingFolderPath();
        try {
            BufferedImage screenshot = MobileScreenCaptor.takeElementScreenshot(appiumDriver, element, null, null);
            File saveFile = Path.of(selfHealingFolder, name + ".png").toFile();
            PathUtil.ensureDirectory((File)saveFile, (boolean)true);
            ImageIO.write((RenderedImage)screenshot, "png", saveFile);
            return saveFile.getAbsolutePath();
        }
        catch (Exception e) {
            SelfHealingController.logError(MessageFormat.format(StringConstants.KW_LOG_INFO_COULD_NOT_SAVE_SCREENSHOT, selfHealingFolder, e.getMessage()), e);
            return "";
        }
    }

    public static String takeScreenShot(AppiumDriver appiumDriver, WebElement element, TestObject testObject, String name) {
        return SelfHealingController.takeScreenShot(appiumDriver, element, testObject.getObjectId() + "_" + name);
    }

    public static String getRelativePathToSelfHealindDir(String screenshotAbsolutePath) {
        String selfHealingFolder = SelfHealingController.getSelfHealingFolderPath();
        return FileUtil.getRelativePath((String)screenshotAbsolutePath, (String)selfHealingFolder);
    }

    public static String getScreenshotAbsolutePath(String screenshotRelativePath) {
        String projectDir = RunConfiguration.getProjectDir();
        return FilenameUtils.concat((String)projectDir, (String)screenshotRelativePath);
    }

    public static BrokenTestObject registerBrokenTestObject(FindElementsResult findResult, TestObject testObject) {
        BrokenTestObject brokenTestObject = SelfHealingController.registerBrokenTestObject(findResult, testObject, RunConfiguration.getReportFolder());
        BrokenTestObject cloneBrokenTestObject = brokenTestObject.clone();
        cloneBrokenTestObject.setPathToScreenshot(findResult.getScreenshot());
        SelfHealingController.saveBrokenTestObject(cloneBrokenTestObject);
        return brokenTestObject;
    }

    public static BrokenTestObject registerBrokenTestObject(FindElementsResult findResult, TestObject brokenTestObject, String dataFolder) {
        String projectDir;
        LocatorStrategy recoveryLocatorStrategy;
        List<WebElement> foundElements = findResult.getElements();
        WebElement foundElement = foundElements.get(0);
        LocatorStrategy proposedLocatorStrategy = recoveryLocatorStrategy = findResult.getLocatorStrategy();
        String proposedLocator = findResult.getLocator();
        String elementScreenshot = findResult.getScreenshot();
        if (StringUtils.isBlank((CharSequence)elementScreenshot)) {
            AppiumDriver driver = MobileDriverFactory.getDriver();
            elementScreenshot = SelfHealingController.takeScreenShot(driver, foundElement, brokenTestObject, recoveryLocatorStrategy.name());
            SelfHealingController.logInfo("Screenshot: " + elementScreenshot);
            findResult.setScreenshot(elementScreenshot);
        }
        if (StringUtils.isNotBlank((CharSequence)elementScreenshot)) {
            try {
                String screenshotRelativePath = SelfHealingController.getRelativePathToSelfHealindDir(elementScreenshot);
                String destScreenshotPath = FilenameUtils.concat((String)dataFolder, (String)screenshotRelativePath);
                File destScreenshot = new File(destScreenshotPath);
                if (!destScreenshot.exists()) {
                    FileUtils.copyFile((File)new File(elementScreenshot), (File)destScreenshot);
                }
                elementScreenshot = destScreenshotPath;
            }
            catch (IOException exception) {
                SelfHealingController.logWarning(MessageFormat.format(StringConstants.KW_LOG_INFO_COULD_NOT_SAVE_SCREENSHOT, dataFolder, exception.getMessage()), exception);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)elementScreenshot) && FileUtil.isInBaseFolder((String)elementScreenshot, (String)(projectDir = RunConfiguration.getProjectDir()))) {
            elementScreenshot = FileUtil.getRelativePath((String)elementScreenshot, (String)projectDir);
        }
        return SelfHealingController.registerBrokenTestObject(brokenTestObject, proposedLocator, proposedLocatorStrategy, recoveryLocatorStrategy, elementScreenshot, dataFolder);
    }
}

