/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.keyword.internal;

import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.enums.mobile.MobilePlatform;
import com.kms.katalon.core.mobile.keyword.internal.MobileSearchEngine;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import java.util.Optional;

public class MobileLocatorFinder {
    public static String findLocator(TestObject testObject, LocatorStrategy strategy) {
        MobileSearchEngine searchEngine = new MobileSearchEngine(null, testObject);
        if (MobilePlatform.ANDROID.equals((Object)((MobileTestObject)testObject).getPlatform())) {
            switch (strategy) {
                case ATTRIBUTES: {
                    return searchEngine.findAndroidAttributesLocator();
                }
                case ACCESSIBILITY: {
                    return searchEngine.findAndroidAccessibilityId();
                }
                case ANDROID_UI_AUTOMATOR: {
                    return searchEngine.findAndroidUIAutomatorSelector();
                }
                case CLASS_NAME: {
                    Optional<TestObjectProperty> match = testObject.getProperties().stream().filter(p -> "class".equals(p.getName())).findFirst();
                    return match.isPresent() ? match.get().getValue() : "";
                }
                case ID: {
                    return searchEngine.findAndroidID();
                }
                case NAME: {
                    return searchEngine.findAndroidName();
                }
                case XPATH: {
                    Optional<TestObjectProperty> match = testObject.getProperties().stream().filter(p -> "xpath".equals(p.getName())).findFirst();
                    return match.isPresent() ? match.get().getValue() : "";
                }
                case IMAGE: {
                    Optional<TestObjectProperty> match = testObject.getProperties().stream().filter(p -> "image".equals(p.getName())).findFirst();
                    return match.isPresent() ? match.get().getValue() : "";
                }
            }
            return "";
        }
        if (MobilePlatform.IOS.equals((Object)((MobileTestObject)testObject).getPlatform())) {
            switch (strategy) {
                case ATTRIBUTES: {
                    return searchEngine.findIOSAttributesLocator();
                }
                case ACCESSIBILITY: {
                    return searchEngine.findIOSAccessibilityId();
                }
                case CLASS_NAME: {
                    Optional<TestObjectProperty> match = testObject.getProperties().stream().filter(p -> "type".equals(p.getName())).findFirst();
                    return match.isPresent() ? match.get().getValue() : "";
                }
                case ID: {
                    return searchEngine.findIOSID();
                }
                case XPATH: {
                    Optional<TestObjectProperty> match = testObject.getProperties().stream().filter(p -> "xpath".equals(p.getName())).findFirst();
                    return match.isPresent() ? match.get().getValue() : "";
                }
                case IOS_CLASS_CHAIN: {
                    return searchEngine.findIOSClassChain();
                }
                case IOS_PREDICATE_STRING: {
                    return searchEngine.findIOSPredicateString();
                }
                case NAME: {
                    return searchEngine.findIOSName();
                }
                case IMAGE: {
                    Optional<TestObjectProperty> match = testObject.getProperties().stream().filter(p -> "image".equals(p.getName())).findFirst();
                    return match.isPresent() ? match.get().getValue() : "";
                }
            }
            return "";
        }
        return "";
    }
}

