/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.core.mobile.keyword.internal;

import com.kms.katalon.core.enums.mobile.LocatorStrategy;
import com.kms.katalon.core.mobile.helper.MobileCommonHelper;
import com.kms.katalon.core.mobile.keyword.internal.SelectorBuilderHelper;
import com.kms.katalon.core.testobject.ConditionType;
import com.kms.katalon.core.testobject.MobileTestObject;
import com.kms.katalon.core.testobject.TestObject;
import com.kms.katalon.core.testobject.TestObjectProperty;
import io.appium.java_client.AppiumBy;
import io.appium.java_client.AppiumDriver;
import io.appium.java_client.android.AndroidDriver;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.WebElement;

public class MobileSearchEngine {
    private AppiumDriver driver;
    private TestObject element;

    public MobileSearchEngine(AppiumDriver driver, TestObject element) {
        this.driver = driver;
        this.element = element;
    }

    public String findAndroidAttributesLocator() {
        return MobileCommonHelper.getAttributeLocatorValue(this.element);
    }

    public String findIOSAttributesLocator() {
        return MobileCommonHelper.getAttributeLocatorValue(this.element);
    }

    public String findIOSID() {
        TestObjectProperty property = this.element.findProperty("name");
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    public String findIOSPredicateString() {
        ArrayList<String> predicates = new ArrayList<String>();
        for (TestObjectProperty property : this.element.getActiveProperties()) {
            String name = property.getName();
            String value = property.getValue();
            if (value == null || !property.isActive()) continue;
            switch (name) {
                case "type": {
                    predicates.add(String.format("type == '%s'", value));
                    break;
                }
                case "enabled": {
                    predicates.add(String.format("enabled == %s", "true".equals(value) ? "1" : "0"));
                    break;
                }
                case "hint": {
                    predicates.add(String.format("hint == '%s'", value));
                    break;
                }
                case "label": {
                    predicates.add(String.format("label == '%s'", value));
                    break;
                }
                case "name": {
                    predicates.add(String.format("name == '%s'", value));
                    break;
                }
                case "visible": {
                    predicates.add(String.format("visible == %s", "true".equals(value) ? "1" : "0"));
                    break;
                }
                case "value": {
                    predicates.add(String.format("name == '%s'", value));
                    break;
                }
            }
        }
        if (predicates.isEmpty()) {
            return "";
        }
        return StringUtils.join(predicates, (String)" AND ");
    }

    public String findIOSClassChain() {
        ArrayList<String> predicates = new ArrayList<String>();
        for (TestObjectProperty property : this.element.getProperties()) {
            String name = property.getName();
            String value = property.getValue();
            if (value == null || !property.isActive()) continue;
            switch (name) {
                case "enabled": {
                    predicates.add(String.format("enabled == %s", "true".equals(value) ? "1" : "0"));
                    break;
                }
                case "hint": {
                    predicates.add(String.format("hint == '%s'", value));
                    break;
                }
                case "label": {
                    predicates.add(String.format("label == '%s'", value));
                    break;
                }
                case "name": {
                    predicates.add(String.format("name == '%s'", value));
                    break;
                }
                case "visible": {
                    predicates.add(String.format("visible == %s", "true".equals(value) ? "1" : "0"));
                    break;
                }
                case "value": {
                    predicates.add(String.format("value == '%s'", value));
                    break;
                }
            }
        }
        if (predicates.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder("**");
        TestObjectProperty typeProp = this.element.findProperty("type");
        if (typeProp != null) {
            builder.append(String.format("/%s", typeProp.getValue()));
        }
        builder.append(String.format("[`%s`]", StringUtils.join(predicates, (String)" AND ")));
        return builder.toString();
    }

    public String findAndroidName() {
        TestObjectProperty property = this.element.findProperty("name");
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    public String findIOSName() {
        TestObjectProperty property = this.element.findProperty("name");
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    public String findIOSAccessibilityId() {
        TestObjectProperty property = this.element.findProperty("name");
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    public String findAndroidID() {
        TestObjectProperty property = this.element.findProperty("resource-id");
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    public String findAndroidAccessibilityId() {
        TestObjectProperty property = this.element.findProperty("content-desc");
        if (property != null) {
            return property.getValue();
        }
        return "";
    }

    public String findAndroidUIAutomatorSelector() {
        StringBuilder selector = new StringBuilder("new UiSelector()");
        TestObjectProperty property = this.element.findProperty("class");
        if (property != null && property.isActive()) {
            if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                selector.append(String.format(".classNameMatches(\"%s\")", property.getValue()));
            } else {
                selector.append(String.format(".className(\"%s\")", property.getValue()));
            }
        }
        if ((property = this.element.findProperty("content-desc")) != null && property.isActive()) {
            if (property.getCondition().equals((Object)ConditionType.CONTAINS)) {
                selector.append(String.format(".descriptionContains(\"%s\")", property.getValue()));
            } else if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                selector.append(String.format(".descriptionMatches(\"%s\")", property.getValue()));
            } else if (property.getCondition().equals((Object)ConditionType.STARTS_WITH)) {
                selector.append(String.format(".descriptionStartsWith(\"%s\")", property.getValue()));
            } else {
                selector.append(String.format(".description(\"%s\")", property.getValue()));
            }
        }
        if ((property = this.element.findProperty("text")) != null && property.isActive() && StringUtils.isNotEmpty((CharSequence)property.getValue())) {
            String propValText = property.getValue().replace("\\n", "\n");
            if (property.getCondition().equals((Object)ConditionType.CONTAINS)) {
                selector.append(String.format(".textContains(\"%s\")", propValText));
            } else if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                selector.append(String.format(".textMatches(\"%s\")", propValText));
            } else if (property.getCondition().equals((Object)ConditionType.STARTS_WITH)) {
                selector.append(String.format(".textStartsWith(\"%s\")", propValText));
            } else {
                selector.append(String.format(".text(\"%s\")", propValText));
            }
        }
        if ((property = this.element.findProperty("resource-id")) != null && property.isActive()) {
            if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                selector.append(String.format(".resourceIdMatches(\"%s\")", property.getValue()));
            } else {
                selector.append(String.format(".resourceId(\"%s\")", property.getValue()));
            }
        }
        if ((property = this.element.findProperty("package")) != null && property.isActive()) {
            if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                selector.append(String.format(".packageNameMatches(\"%s\")", property.getValue()));
            } else {
                selector.append(String.format(".packageName(\"%s\")", property.getValue()));
            }
        }
        if ((property = this.element.findProperty("enabled")) != null && property.isActive()) {
            selector.append(String.format(".enabled(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("clickable")) != null && property.isActive()) {
            selector.append(String.format(".clickable(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("long-clickable")) != null && property.isActive()) {
            selector.append(String.format(".longClickable(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("checkable")) != null && property.isActive()) {
            selector.append(String.format(".checkable(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("checked")) != null && property.isActive()) {
            selector.append(String.format(".checked(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("focusable")) != null && property.isActive()) {
            selector.append(String.format(".focusable(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("focused")) != null && property.isActive()) {
            selector.append(String.format(".focused(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("scrollable")) != null && property.isActive()) {
            selector.append(String.format(".scrollable(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("selected")) != null && property.isActive()) {
            selector.append(String.format(".selected(%b)", Boolean.parseBoolean(property.getValue())));
        }
        if ((property = this.element.findProperty("instance")) != null && property.isActive()) {
            selector.append(String.format(".instance(%s)", property.getValue()));
        }
        if ((property = this.element.findProperty("index")) != null && property.isActive()) {
            selector.append(String.format(".index(%s)", property.getValue()));
        }
        return selector.toString();
    }

    private List<WebElement> findAndroidElements(AndroidDriver driver) {
        String xpath = null;
        TestObjectProperty xpathProp = this.element.findProperty("xpath");
        if (xpathProp != null && xpathProp.isActive()) {
            xpath = xpathProp.getValue();
        }
        if (xpath == null) {
            TestObjectProperty uiAutomatorProp = this.element.findProperty("UIAutomator");
            if (uiAutomatorProp != null && uiAutomatorProp.isActive()) {
                WebElement foundElement = driver.findElement(AppiumBy.androidUIAutomator((String)uiAutomatorProp.getValue()));
                if (foundElement != null) {
                    ArrayList<WebElement> elementList = new ArrayList<WebElement>();
                    elementList.add(foundElement);
                    return elementList;
                }
                return null;
            }
            StringBuilder selector = new StringBuilder("new UiSelector()");
            TestObjectProperty property = this.element.findProperty("class");
            if (property != null && property.isActive()) {
                if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                    selector.append(String.format(".classNameMatches(\"%s\")", property.getValue()));
                } else {
                    selector.append(String.format(".className(\"%s\")", property.getValue()));
                }
            }
            if ((property = this.element.findProperty("content-desc")) != null && property.isActive()) {
                if (property.getCondition().equals((Object)ConditionType.CONTAINS)) {
                    selector.append(String.format(".descriptionContains(\"%s\")", property.getValue()));
                } else if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                    selector.append(String.format(".descriptionMatches(\"%s\")", property.getValue()));
                } else if (property.getCondition().equals((Object)ConditionType.STARTS_WITH)) {
                    selector.append(String.format(".descriptionStartsWith(\"%s\")", property.getValue()));
                } else {
                    selector.append(String.format(".description(\"%s\")", property.getValue()));
                }
            }
            if ((property = this.element.findProperty("text")) != null && property.isActive()) {
                String propValText = property.getValue().replace("\\n", "\n");
                if (property.getCondition().equals((Object)ConditionType.CONTAINS)) {
                    selector.append(String.format(".textContains(\"%s\")", propValText));
                } else if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                    selector.append(String.format(".textMatches(\"%s\")", propValText));
                } else if (property.getCondition().equals((Object)ConditionType.STARTS_WITH)) {
                    selector.append(String.format(".textStartsWith(\"%s\")", propValText));
                } else {
                    selector.append(String.format(".text(\"%s\")", propValText));
                }
            }
            if ((property = this.element.findProperty("resource-id")) != null && property.isActive()) {
                if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                    selector.append(String.format(".resourceIdMatches(\"%s\")", property.getValue()));
                } else {
                    selector.append(String.format(".resourceId(\"%s\")", property.getValue()));
                }
            }
            if ((property = this.element.findProperty("package")) != null && property.isActive()) {
                if (property.getCondition().equals((Object)ConditionType.EXPRESSION)) {
                    selector.append(String.format(".packageNameMatches(\"%s\")", property.getValue()));
                } else {
                    selector.append(String.format(".packageName(\"%s\")", property.getValue()));
                }
            }
            if ((property = this.element.findProperty("enabled")) != null && property.isActive()) {
                selector.append(String.format(".enabled(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("clickable")) != null && property.isActive()) {
                selector.append(String.format(".clickable(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("long-clickable")) != null && property.isActive()) {
                selector.append(String.format(".longClickable(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("checkable")) != null && property.isActive()) {
                selector.append(String.format(".checkable(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("checked")) != null && property.isActive()) {
                selector.append(String.format(".checked(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("focusable")) != null && property.isActive()) {
                selector.append(String.format(".focusable(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("focused")) != null && property.isActive()) {
                selector.append(String.format(".focused(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("scrollable")) != null && property.isActive()) {
                selector.append(String.format(".scrollable(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("selected")) != null && property.isActive()) {
                selector.append(String.format(".selected(%b)", Boolean.parseBoolean(property.getValue())));
            }
            if ((property = this.element.findProperty("instance")) != null && property.isActive()) {
                selector.append(String.format(".instance(%s)", property.getValue()));
            }
            if ((property = this.element.findProperty("index")) != null && property.isActive()) {
                selector.append(String.format(".index(%s)", property.getValue()));
            }
            return driver.findElements(AppiumBy.androidUIAutomator((String)selector.toString()));
        }
        List<TestObjectProperty> specialProperties = SelectorBuilderHelper.escapeSpecialProperties(this.element.getProperties());
        List elements = driver.findElements(AppiumBy.xpath((String)SelectorBuilderHelper.buildXpathFromProperties(this.element.getProperties())));
        if (!specialProperties.isEmpty()) {
            int i = elements.size() - 1;
            while (i >= 0) {
                WebElement foundElement = (WebElement)elements.get(i);
                if (!this.isMatchedAndroidElement(foundElement, specialProperties)) {
                    elements.remove(i);
                }
                --i;
            }
        }
        return elements;
    }

    private boolean isMatchedAndroidElement(WebElement actualElement, List<TestObjectProperty> expectedProps) {
        String actualValue = null;
        String expectedValue = null;
        boolean isMatched = true;
        block36: for (TestObjectProperty property : expectedProps) {
            switch (property.getName()) {
                case "checkable": {
                    actualValue = actualElement.getAttribute("checkable");
                    break;
                }
                case "checked": {
                    actualValue = actualElement.getAttribute("checked");
                    break;
                }
                case "class": {
                    actualValue = actualElement.getTagName();
                    break;
                }
                case "clickable": {
                    actualValue = actualElement.getAttribute("clickable");
                    break;
                }
                case "content-desc": {
                    actualValue = actualElement.getAttribute("content-desc");
                    break;
                }
                case "enabled": {
                    actualValue = String.valueOf(actualElement.isEnabled());
                    break;
                }
                case "focusable": {
                    actualValue = actualElement.getAttribute("focusable");
                    break;
                }
                case "focused": {
                    actualValue = actualElement.getAttribute("focused");
                    break;
                }
                case "instance": {
                    actualValue = actualElement.getAttribute("instance");
                    break;
                }
                case "long-clickable": {
                    actualValue = actualElement.getAttribute("long-clickable");
                    break;
                }
                case "package": {
                    actualValue = actualElement.getAttribute("package");
                    break;
                }
                case "password": {
                    actualValue = actualElement.getAttribute("password");
                    break;
                }
                case "resource-id": {
                    actualValue = actualElement.getAttribute("resource-id");
                    break;
                }
                case "scrollable": {
                    actualValue = actualElement.getAttribute("scrollable");
                    break;
                }
                case "selected": {
                    actualValue = String.valueOf(actualElement.isSelected());
                    break;
                }
                case "text": {
                    actualValue = actualElement.getText();
                    break;
                }
                default: {
                    continue block36;
                }
            }
            expectedValue = property.getValue();
            isMatched &= this.isMatchedValue(actualValue, expectedValue, property.getCondition());
        }
        return isMatched;
    }

    public WebElement findWebElement(boolean addLogEntries) throws Exception {
        if (this.element instanceof MobileTestObject) {
            List<WebElement> elements = this.findElementsByMobileLocator();
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            return elements.get(0);
        }
        if (this.driver instanceof AndroidDriver) {
            List<WebElement> elements = this.findAndroidElements((AndroidDriver)this.driver);
            if (elements == null || elements.isEmpty()) {
                return null;
            }
            return elements.get(0);
        }
        List<WebElement> elements = this.findIosElements(this.driver);
        if (elements == null || elements.isEmpty()) {
            return null;
        }
        return elements.get(0);
    }

    public List<WebElement> findWebElements(boolean addLogEntries) throws Exception {
        if (this.element instanceof MobileTestObject) {
            return this.findElementsByMobileLocator();
        }
        if (this.driver instanceof AndroidDriver) {
            List<WebElement> elements = this.findAndroidElements((AndroidDriver)this.driver);
            return elements;
        }
        List<WebElement> elements = this.findIosElements(this.driver);
        return elements;
    }

    public List<WebElement> findElementsByMobileLocator(LocatorStrategy locatorStrategy) {
        MobileTestObject mobileTestObject = (MobileTestObject)this.element;
        Map locatorCollection = mobileTestObject.getLocatorCollection();
        String mobileLocator = (String)locatorCollection.get(locatorStrategy);
        switch (locatorStrategy) {
            case ACCESSIBILITY: {
                return this.driver.findElements(AppiumBy.accessibilityId((String)mobileLocator));
            }
            case ANDROID_UI_AUTOMATOR: {
                return this.driver.findElements(AppiumBy.androidUIAutomator((String)mobileLocator));
            }
            case ANDROID_VIEWTAG: {
                return this.driver.findElements(AppiumBy.androidViewTag((String)mobileLocator));
            }
            case CUSTOM: {
                return this.driver.findElements(AppiumBy.custom((String)mobileLocator));
            }
            case IMAGE: {
                return this.driver.findElements(AppiumBy.image((String)mobileLocator));
            }
            case IOS_CLASS_CHAIN: {
                return this.driver.findElements(AppiumBy.iOSClassChain((String)mobileLocator));
            }
            case IOS_PREDICATE_STRING: {
                return this.driver.findElements(AppiumBy.iOSNsPredicateString((String)mobileLocator));
            }
            case CLASS_NAME: {
                return this.driver.findElements(By.className((String)mobileLocator));
            }
            case ID: {
                return this.driver.findElements(By.id((String)mobileLocator));
            }
            case NAME: {
                return this.driver.findElements(By.name((String)mobileLocator));
            }
            case ATTRIBUTES: 
            case XPATH: {
                return this.driver.findElements(By.xpath((String)mobileLocator));
            }
        }
        return null;
    }

    public List<WebElement> findElementsByMobileLocator() {
        MobileTestObject mobileTestObject = (MobileTestObject)this.element;
        String mobileLocator = mobileTestObject.getLocator();
        switch (mobileTestObject.getLocatorStrategy()) {
            case ACCESSIBILITY: {
                return this.driver.findElements(AppiumBy.accessibilityId((String)mobileLocator));
            }
            case ANDROID_UI_AUTOMATOR: {
                return this.driver.findElements(AppiumBy.androidUIAutomator((String)mobileLocator));
            }
            case ANDROID_VIEWTAG: {
                return this.driver.findElements(AppiumBy.androidViewTag((String)mobileLocator));
            }
            case CUSTOM: {
                return this.driver.findElements(AppiumBy.custom((String)mobileLocator));
            }
            case IMAGE: {
                return this.driver.findElements(AppiumBy.image((String)mobileLocator));
            }
            case IOS_CLASS_CHAIN: {
                return this.driver.findElements(AppiumBy.iOSClassChain((String)mobileLocator));
            }
            case IOS_PREDICATE_STRING: {
                return this.driver.findElements(AppiumBy.iOSNsPredicateString((String)mobileLocator));
            }
            case CLASS_NAME: {
                return this.driver.findElements(By.className((String)mobileLocator));
            }
            case ID: {
                return this.driver.findElements(By.id((String)mobileLocator));
            }
            case NAME: {
                return this.driver.findElements(By.name((String)mobileLocator));
            }
            case ATTRIBUTES: 
            case XPATH: {
                return this.driver.findElements(By.xpath((String)mobileLocator));
            }
        }
        return null;
    }

    private List<WebElement> findIosElements(AppiumDriver driver) {
        String xpath = null;
        TestObjectProperty xpathProp = this.element.findProperty("xpath");
        if (xpathProp != null && xpathProp.isActive()) {
            xpath = xpathProp.getValue();
        }
        TestObjectProperty typeProp = this.element.findProperty("type");
        String type = null;
        if (typeProp != null && typeProp.isActive()) {
            type = typeProp.getValue();
        }
        if (xpath == null && type == null) {
            List elements = null;
            String selectorValue = null;
            TestObjectProperty selectorProp = this.element.findProperty("name");
            if (selectorProp != null && selectorProp.isActive()) {
                selectorValue = selectorProp.getValue();
            }
            if (selectorValue != null) {
                elements = driver.findElements(AppiumBy.name(selectorValue));
            }
            if (elements != null && !elements.isEmpty()) {
                int i = elements.size() - 1;
                while (i >= 0) {
                    WebElement foundElement = (WebElement)elements.get(i);
                    if (!this.isMatchedIosElement(foundElement, this.element.getActiveProperties())) {
                        elements.remove(i);
                    }
                    --i;
                }
            }
            return elements;
        }
        List<TestObjectProperty> specialProperties = SelectorBuilderHelper.escapeSpecialProperties(this.element.getActiveProperties());
        List elements = driver.findElements(AppiumBy.xpath((String)SelectorBuilderHelper.buildXpathFromProperties(this.element.getActiveProperties())));
        if (!specialProperties.isEmpty()) {
            int i = elements.size() - 1;
            while (i >= 0) {
                WebElement foundElement = (WebElement)elements.get(i);
                if (!this.isMatchedIosElement(foundElement, specialProperties)) {
                    elements.remove(i);
                }
                --i;
            }
        }
        return elements;
    }

    private boolean isMatchedIosElement(WebElement actualElement, List<TestObjectProperty> expectedProps) {
        String actualValue = null;
        String expectedValue = null;
        boolean isMatched = true;
        block18: for (TestObjectProperty property : expectedProps) {
            switch (property.getName()) {
                case "type": {
                    actualValue = actualElement.getTagName();
                    break;
                }
                case "enabled": {
                    actualValue = String.valueOf(actualElement.isEnabled());
                    break;
                }
                case "hint": {
                    actualValue = actualElement.getAttribute("hint");
                    break;
                }
                case "label": {
                    actualValue = actualElement.getAttribute("label");
                    break;
                }
                case "name": {
                    actualValue = actualElement.getAttribute("name");
                    break;
                }
                case "visible": {
                    actualValue = String.valueOf(actualElement.isDisplayed());
                    break;
                }
                case "value": {
                    actualValue = actualElement.getAttribute("value");
                    break;
                }
                default: {
                    continue block18;
                }
            }
            expectedValue = property.getValue();
            isMatched &= this.isMatchedValue(actualValue, expectedValue, property.getCondition());
        }
        return isMatched;
    }

    private boolean isMatchedValue(String actualValue, String expectedValue, ConditionType operatorType) {
        switch (operatorType) {
            case CONTAINS: {
                return actualValue.contains(expectedValue);
            }
            case ENDS_WITH: {
                return actualValue.endsWith(expectedValue);
            }
            case EQUALS: {
                return actualValue.equals(expectedValue);
            }
            case EXPRESSION: {
                return actualValue.matches(expectedValue);
            }
            case NOT_CONTAIN: {
                return !actualValue.contains(expectedValue);
            }
            case STARTS_WITH: {
                return actualValue.startsWith(expectedValue);
            }
        }
        return false;
    }
}

