/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.builder;

import cucumber.eclipse.editor.steps.UniversalStepDefinitionsProvider;
import cucumber.eclipse.steps.integration.StepPreferences;
import cucumber.eclipse.steps.integration.marker.MarkerFactory;
import java.io.IOException;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceDeltaVisitor;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CucumberStepDefinitionsBuilder {
    private static CucumberStepDefinitionsBuilder INSTANCE;
    protected final UniversalStepDefinitionsProvider stepDefinitionsProvider = UniversalStepDefinitionsProvider.INSTANCE;
    protected MarkerFactory markerFactory = MarkerFactory.INSTANCE;
    protected StepPreferences cucumberPreferences = StepPreferences.INSTANCE;
    private IProject project;

    public static CucumberStepDefinitionsBuilder getInstance() {
        if (INSTANCE == null) {
            INSTANCE = new CucumberStepDefinitionsBuilder();
        }
        return INSTANCE;
    }

    public void fullBuild(IProject project, IProgressMonitor monitor) throws CoreException {
        try {
            this.project = project;
            this.stepDefinitionsProvider.clean(project);
            IFolder stepDefinitionsFolder = project.getFolder("Include");
            if (stepDefinitionsFolder.exists()) {
                stepDefinitionsFolder.accept((IResourceVisitor)new CucumberStepDefinitionsBuildVisitor(this.markerFactory, monitor));
            }
            if ((stepDefinitionsFolder = project.getFolder("Drivers")).exists()) {
                stepDefinitionsFolder.accept((IResourceVisitor)new CucumberStepDefinitionsBuildVisitor(this.markerFactory, monitor));
            }
            this.stepDefinitionsProvider.persist(project, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.editor", e.getMessage(), (Throwable)e));
        }
    }

    public void fullBuild(IProgressMonitor monitor) throws CoreException {
        if (this.project == null) {
            return;
        }
        this.fullBuild(this.project, monitor);
    }

    public void incrementalBuild(IResourceDelta delta, IProgressMonitor monitor) throws CoreException {
        try {
            IProject project = delta.getResource().getProject();
            if (!this.stepDefinitionsProvider.isInitialized(project)) {
                this.stepDefinitionsProvider.load(project);
            }
            delta.accept((IResourceDeltaVisitor)new CucumberStepDefinitionsBuildVisitor(this.markerFactory, monitor));
            this.stepDefinitionsProvider.persist(project, monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.editor", e.getMessage(), (Throwable)e));
        }
    }

    public void incrementalBuild(IResource resource, IProgressMonitor monitor) throws CoreException {
        try {
            IProject project = resource.getProject();
            if (!this.stepDefinitionsProvider.isInitialized(project)) {
                this.stepDefinitionsProvider.load(project);
            }
            new CucumberStepDefinitionsBuildVisitor(this.markerFactory, monitor).visit(resource);
            this.stepDefinitionsProvider.persist(this.getProject(), monitor);
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new CoreException((IStatus)new Status(4, "cucumber.eclipse.editor", e.getMessage(), (Throwable)e));
        }
    }

    public void clean(IProgressMonitor monitor) throws CoreException {
        IProject project = this.getProject();
        this.stepDefinitionsProvider.clean(project);
        project.accept((IResourceVisitor)new CucumberStepDefinitionsCleanBuildVisitor(this.markerFactory, monitor));
    }

    private IProject getProject() {
        return this.project;
    }

    class CucumberStepDefinitionsBuildVisitor
    implements IResourceVisitor,
    IResourceDeltaVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;

        public CucumberStepDefinitionsBuildVisitor(MarkerFactory markerFactory, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
        }

        public boolean visit(IResource resource) throws CoreException {
            boolean shouldVisit;
            if (this.monitor.isCanceled()) {
                return false;
            }
            if (!resource.exists()) {
                return true;
            }
            String fullPath = resource.getFullPath().toString();
            boolean bl = shouldVisit = fullPath.contains("/bin/groovy") || fullPath.contains("/bin/.cucumber") || fullPath.contains("Drivers") || fullPath.contains("Include");
            if (!shouldVisit) {
                return false;
            }
            if (CucumberStepDefinitionsBuilder.this.stepDefinitionsProvider.support(resource)) {
                this.markerFactory.cleanMarkers(resource);
                CucumberStepDefinitionsBuilder.this.stepDefinitionsProvider.findStepDefinitions(resource, this.markerFactory, this.monitor);
            }
            return true;
        }

        public boolean visit(IResourceDelta delta) throws CoreException {
            boolean projectDescriptionChanged;
            if (this.monitor.isCanceled()) {
                return false;
            }
            int flags = delta.getFlags();
            boolean contentChanged = (flags & 0x100) != 0;
            boolean bl = projectDescriptionChanged = (flags & 0x80000) != 0;
            if (contentChanged || projectDescriptionChanged) {
                boolean shouldVisit;
                IResource resource = delta.getResource();
                String fullPath = resource.getFullPath().toString();
                boolean bl2 = shouldVisit = fullPath.contains("/bin/groovy") || fullPath.contains("/bin/.cucumber") || fullPath.contains("Drivers") || fullPath.contains("Include");
                if (!shouldVisit) {
                    return false;
                }
                return this.visit(resource);
            }
            return true;
        }
    }

    class CucumberStepDefinitionsCleanBuildVisitor
    implements IResourceVisitor {
        private IProgressMonitor monitor;
        private MarkerFactory markerFactory;

        public CucumberStepDefinitionsCleanBuildVisitor(MarkerFactory markerFactory, IProgressMonitor monitor) {
            this.monitor = monitor;
            this.markerFactory = markerFactory;
        }

        public boolean visit(IResource resource) throws CoreException {
            if (this.monitor.isCanceled()) {
                return false;
            }
            this.markerFactory.cleanMarkers(resource);
            return true;
        }
    }
}

