/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.contentassist;

import cucumber.eclipse.editor.steps.UniversalStepDefinitionsProvider;
import cucumber.eclipse.steps.integration.StepDefinition;
import gherkin.I18n;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.swt.graphics.Image;

public class CucumberContentAssist {
    private final String NOSTEPS = "No Step Definition Found";
    private String[] junkWords = new String[]{"* ", "Business Need", "Ability", "Scenario Template", "Scenarios"};
    public final String STARTSWITH_ANYSPACE = "^\\s+";
    public final String ENDSWITH_ANYSPACE = "(\\s$)+";
    public final String WORDS_STARTSWITH_SPACE = "(^\\s)[\\w]+";
    public final String STARTS_ANY = "^[\\w\\d\\S][^\\,]*";
    public final String ANY = "[\\w\\d\\S][\\,]*";
    public final String COMMA_SPACE_REGEX = "(\\,|\\s$)+";
    public static final String INTEGER = "(\\d+)";
    public static final String REAL_NUMBER = "(\\d+\\.\\d+)";
    public static final String TEXT = "([\"]*)";
    public static final String ANY_TEXT = "(.*?)";
    public static final String START_OR_END = "^\\^|\\$$";
    public static final String P_CHAR = "<p>|";
    private List<String> stepDetailList = null;
    private List<String> matchedStepList = null;
    private CompletionProposal allStepsProposal = null;
    private CompletionProposal noProposal = null;
    CompletionProposal matchedStepsProposal = null;
    private Set<StepDefinition> importedSteps = null;

    public CucumberContentAssist(String lang, IProject project) throws CoreException {
        this.importedSteps = UniversalStepDefinitionsProvider.INSTANCE.getStepDefinitions(project);
        this.stepDetailList = new ArrayList<String>();
        this.matchedStepList = new ArrayList<String>();
    }

    public List<String> getStepKeyWords(I18n i18n) {
        List stepKeywords = i18n.getStepKeywords();
        stepKeywords.removeAll(Arrays.asList(this.junkWords));
        return stepKeywords;
    }

    public void collectAllSteps(String matchPrefix) {
        String lineNumber = "";
        String stepDetailInfo = null;
        String stepSource = null;
        String packageName = null;
        if (!this.importedSteps.isEmpty()) {
            for (StepDefinition step : this.importedSteps) {
                String stepText = CucumberContentAssist.getStepName(step.getExpression().getText());
                if (step.getLineNumber() != 0) {
                    if (step.getSource() != null) {
                        stepSource = CucumberContentAssist.getSourceName(step.getSource().toString());
                    }
                    lineNumber = String.valueOf(step.getLineNumber());
                    stepDetailInfo = String.valueOf(stepText) + " : " + stepSource + ":" + lineNumber;
                } else {
                    stepSource = CucumberContentAssist.getSourceName(step.getSourceName());
                    packageName = step.getPackageName();
                    stepDetailInfo = String.valueOf(stepText) + " : " + stepSource + ":" + packageName;
                }
                if (stepText.startsWith(matchPrefix) && matchPrefix.matches("^[\\w\\d\\S][^\\,]*")) {
                    this.matchedStepList.add(stepDetailInfo);
                } else if (stepText.contains(matchPrefix)) {
                    this.matchedStepList.add(stepDetailInfo);
                }
                this.stepDetailList.add(stepDetailInfo);
            }
        }
    }

    public void importStepProposals(String prefix, String preStep, int offset, Image ICON, String stepDetail, ArrayList<ICompletionProposal> result) {
        String stepWithSource = null;
        String stepText = null;
        String stepSource = null;
        String lineNumber = null;
        String stepDetails = null;
        String packageName = null;
        stepWithSource = stepDetail.substring(0, stepDetail.lastIndexOf(":")).trim();
        stepText = stepWithSource.substring(0, stepWithSource.lastIndexOf(":")).trim();
        stepSource = stepWithSource.substring(stepWithSource.lastIndexOf(":") + 1).trim();
        if (stepSource.endsWith(".java")) {
            lineNumber = stepDetail.substring(stepDetail.lastIndexOf(":") + 1).trim();
            stepDetails = "Step : " + stepText + "\nSource : " + stepSource + "\nLine Number : " + lineNumber;
        } else if (stepSource.endsWith(".class")) {
            packageName = stepDetail.substring(stepDetail.lastIndexOf(":") + 1).trim();
            stepDetails = "Step : " + stepText + "\nSource : " + stepSource + "\nPackage : " + packageName;
        }
        if (preStep.length() > prefix.length()) {
            this.allStepsProposal = new CompletionProposal(this.getUserStep(stepText), offset - prefix.length(), preStep.length(), stepText.length(), ICON, stepWithSource, null, stepDetails);
        } else if (stepText.startsWith(prefix)) {
            this.allStepsProposal = new CompletionProposal(this.getUserStep(stepText).replace(prefix, ""), offset, 0, stepText.length(), ICON, stepWithSource, null, stepDetails);
        } else if (stepText.contains(prefix)) {
            this.allStepsProposal = new CompletionProposal(this.getUserStep(stepText), offset - prefix.length(), preStep.length(), stepText.length(), ICON, stepWithSource, null, stepDetails);
        }
        result.add((ICompletionProposal)this.allStepsProposal);
    }

    public void displayNoProposal(int offset, Image ICON, ArrayList<ICompletionProposal> result) {
        this.noProposal = new CompletionProposal("", offset, 0, 0, ICON, "No Step Definition Found", null, null);
        result.add((ICompletionProposal)this.noProposal);
    }

    public List<String> importAllStepList() {
        return this.stepDetailList;
    }

    public List<String> importMatchedStepList() {
        return this.matchedStepList;
    }

    public static String getStepName(String myStep) {
        myStep = myStep.replaceAll(START_OR_END, "");
        return myStep;
    }

    public static String getSourceName(String mySource) {
        if (mySource.contains("/")) {
            mySource = mySource.substring(mySource.lastIndexOf("/")).replace("/", "");
        }
        return mySource;
    }

    public void removeJunkWords(List<String> keywords) {
        List<String> junks = Arrays.asList(this.junkWords);
        keywords.removeAll(junks);
    }

    public List<String> getJunkList() {
        List<String> junkList = Arrays.asList(this.junkWords);
        return junkList;
    }

    public String lastPrefix(String string, List<String> keywords) {
        String lastStep;
        String longestMatch = null;
        for (String keyword : keywords) {
            if (!string.startsWith(keyword) || longestMatch != null && keyword.length() <= longestMatch.length()) continue;
            longestMatch = keyword;
        }
        String string2 = lastStep = longestMatch != null ? string.substring(longestMatch.length()) : string;
        if (lastStep.contains(",")) {
            lastStep = lastStep.substring(lastStep.lastIndexOf(",") + 1).trim();
        }
        return lastStep;
    }

    public String getUserStep(String stepText) {
        stepText = stepText.replace(P_CHAR, "");
        stepText = stepText.replace(INTEGER, "{integer-number}");
        stepText = stepText.replace(REAL_NUMBER, "{real-number}");
        stepText = stepText.replace(TEXT, "{text}");
        stepText = stepText.replace(ANY_TEXT, "{any-text}");
        stepText = stepText.replaceAll(START_OR_END, "");
        return stepText;
    }
}

