/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.editors.ColorManager;
import cucumber.eclipse.editor.editors.Editor;
import cucumber.eclipse.editor.editors.GherkinColors;
import cucumber.eclipse.editor.editors.GherkinDamagerRepairer;
import cucumber.eclipse.editor.editors.GherkinKeywordScanner;
import cucumber.eclipse.editor.editors.GherkinKeywordsAssistProcessor;
import cucumber.eclipse.editor.editors.GherkinReconcilingStrategy;
import cucumber.eclipse.editor.editors.jumpto.StepHyperlinkDetector;
import cucumber.eclipse.editor.markers.MarkerResolutionProposal;
import cucumber.eclipse.editor.markers.StepCreationMarkerResolutionGenerator;
import cucumber.eclipse.steps.integration.StepPreferences;
import java.util.Arrays;
import java.util.Iterator;
import org.eclipse.core.resources.IMarker;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.contentassist.ContentAssistant;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContentAssistant;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.quickassist.IQuickAssistAssistant;
import org.eclipse.jface.text.quickassist.IQuickAssistInvocationContext;
import org.eclipse.jface.text.quickassist.IQuickAssistProcessor;
import org.eclipse.jface.text.quickassist.QuickAssistAssistant;
import org.eclipse.jface.text.reconciler.IReconciler;
import org.eclipse.jface.text.reconciler.IReconcilingStrategy;
import org.eclipse.jface.text.reconciler.MonoReconciler;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.ui.IMarkerResolution;
import org.eclipse.ui.editors.text.TextSourceViewerConfiguration;
import org.eclipse.ui.texteditor.MarkerAnnotation;

public class GherkinConfiguration
extends TextSourceViewerConfiguration {
    private GherkinKeywordScanner keywordScanner;
    private ColorManager colorManager;
    private Editor editor;

    public GherkinConfiguration(Editor editor, ColorManager colorManager) {
        this.editor = editor;
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type"};
    }

    protected GherkinKeywordScanner getGherkinKeywordScanner() {
        if (this.keywordScanner == null) {
            this.keywordScanner = new GherkinKeywordScanner(this.colorManager);
            this.keywordScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor(GherkinColors.DEFAULT))));
        }
        return this.keywordScanner;
    }

    public IQuickAssistAssistant getQuickAssistAssistant(ISourceViewer sourceViewer) {
        QuickAssistAssistant quickAssist = new QuickAssistAssistant();
        quickAssist.setQuickAssistProcessor(new IQuickAssistProcessor(){

            public String getErrorMessage() {
                return null;
            }

            public boolean canFix(Annotation annotation) {
                return true;
            }

            public boolean canAssist(IQuickAssistInvocationContext invocationContext) {
                return false;
            }

            public ICompletionProposal[] computeQuickAssistProposals(IQuickAssistInvocationContext invocationContext) {
                IAnnotationModel annotationModel = invocationContext.getSourceViewer().getAnnotationModel();
                Iterator i = annotationModel.getAnnotationIterator();
                while (i.hasNext()) {
                    Annotation testAnnotation = (Annotation)i.next();
                    if (!annotationModel.getPosition(testAnnotation).includes(GherkinConfiguration.this.editor.getSelection().getOffset()) || !(testAnnotation instanceof MarkerAnnotation)) continue;
                    IMarker marker = ((MarkerAnnotation)testAnnotation).getMarker();
                    IMarkerResolution[] markerResolutions = new StepCreationMarkerResolutionGenerator().getResolutions(marker);
                    ICompletionProposal[] completionProposals = new ICompletionProposal[markerResolutions.length];
                    int j = 0;
                    while (j < markerResolutions.length) {
                        completionProposals[j] = new MarkerResolutionProposal(marker, markerResolutions[j]);
                        ++j;
                    }
                    return completionProposals;
                }
                return null;
            }
        });
        quickAssist.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
        return quickAssist;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        GherkinDamagerRepairer dr = new GherkinDamagerRepairer((ITokenScanner)this.getGherkinKeywordScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        return reconciler;
    }

    public IContentAssistant getContentAssistant(ISourceViewer sourceViewer) {
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        if (store.getBoolean(StepPreferences.PREF_CHECK_STEP_DEFINITIONS)) {
            ContentAssistant ca = new ContentAssistant();
            GherkinKeywordsAssistProcessor cap = new GherkinKeywordsAssistProcessor(this.editor);
            ca.setContentAssistProcessor((IContentAssistProcessor)cap, "__dftl_partition_content_type");
            ca.setInformationControlCreator(this.getInformationControlCreator(sourceViewer));
            ca.setStatusMessage("<Step>:<Class>, Press 'Ctrl+SPace' For Cucumber Assistance");
            ca.setStatusLineVisible(true);
            ca.enableAutoActivation(true);
            ca.setAutoActivationDelay(500);
            return ca;
        }
        return null;
    }

    public IReconciler getReconciler(ISourceViewer sourceViewer) {
        GherkinReconcilingStrategy strategy = new GherkinReconcilingStrategy(this.editor);
        MonoReconciler reconciler = new MonoReconciler((IReconcilingStrategy)strategy, false);
        return reconciler;
    }

    public int getTabWidth(ISourceViewer sourceViewer) {
        return 2;
    }

    public IHyperlinkDetector[] getHyperlinkDetectors(ISourceViewer sourceViewer) {
        IHyperlinkDetector[] hyperlinkDetectors = super.getHyperlinkDetectors(sourceViewer);
        StepHyperlinkDetector stepHyperlinkDetector = new StepHyperlinkDetector(this.editor);
        IHyperlinkDetector[] gherkinHyperlinkDetectors = Arrays.copyOf(hyperlinkDetectors, hyperlinkDetectors.length + 1);
        gherkinHyperlinkDetectors[hyperlinkDetectors.length] = stepHyperlinkDetector;
        return gherkinHyperlinkDetectors;
    }
}

