/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors;

import cucumber.eclipse.editor.Activator;
import cucumber.eclipse.editor.editors.PrettyFormatter;
import gherkin.formatter.Formatter;
import gherkin.lexer.LexingError;
import gherkin.parser.ParseError;
import gherkin.parser.Parser;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.text.edits.TextEdit;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class GherkinFormatterUtil {
    public static String format(String contents) {
        StringWriter output = new StringWriter();
        PrintWriter out = new PrintWriter(output);
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        PrettyFormatter formatter = PrettyFormatter.builder().output(out).monochrome(true).executing(false).rightAlignNumeric(store.getBoolean("cucumber.eclipse.editor.format_right_align_numeric_values_in_tables")).centerSteps(store.getBoolean("cucumber.eclipse.editor.format_center_steps")).preserveBlankLineBetweenSteps(store.getBoolean("cucumber.eclipse.editor.format_preserve_blank_line_between_steps")).indentation(store.getString("cucumber.eclipse.editor.indentation_style")).build();
        List<String> trailingComments = GherkinFormatterUtil.getTrailingComments(contents);
        new Parser((Formatter)formatter).parse(contents, "", Integer.valueOf(0));
        GherkinFormatterUtil.appendTrailingComments(out, trailingComments);
        out.flush();
        return output.toString();
    }

    private static void appendTrailingComments(PrintWriter out, List<String> unattachedComments) {
        for (String unattachedComment : unattachedComments) {
            out.print(String.valueOf(unattachedComment) + "\n");
        }
    }

    private static List<String> getTrailingComments(String contents) {
        ArrayList<String> unattachedComments = new ArrayList<String>();
        String[] split = contents.split("\n");
        int i = split.length - 1;
        while (i >= 0) {
            if (!GherkinFormatterUtil.isComment(split[i])) break;
            unattachedComments.add(split[i]);
            --i;
        }
        Collections.reverse(unattachedComments);
        return unattachedComments;
    }

    private static boolean isComment(String line) {
        return line.trim().startsWith("#");
    }

    public static TextEdit formatTextEdit(String contents, int i, String string) {
        return null;
    }

    public static void format(IEditorPart editorPart) {
        ITextEditor editor = (ITextEditor)editorPart;
        Shell shell = editorPart.getSite().getShell();
        IDocument doc = editor.getDocumentProvider().getDocument((Object)editor.getEditorInput());
        String contents = doc.get();
        try {
            String formatted = GherkinFormatterUtil.format(contents);
            doc.replace(0, doc.getLength(), formatted);
        }
        catch (ParseError e) {
            MessageDialog.openInformation((Shell)shell, (String)"Unable to pretty format.", (String)("One can only format a feature file that has no parse errors: \nThe following parse error was encountered: [" + e.getMessage() + "]"));
        }
        catch (LexingError e) {
            MessageDialog.openInformation((Shell)shell, (String)"Unable to pretty format.", (String)("One can only format a feature file that has no lexing errors: \nThe following lex error was encountered: [" + e.getMessage() + "]"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

