/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.editor.editors.jumpto;

import cucumber.eclipse.editor.editors.Editor;
import cucumber.eclipse.editor.editors.jumpto.JumpToStepDefinition;
import cucumber.eclipse.editor.editors.jumpto.StepHyperlink;
import cucumber.eclipse.editor.steps.StepDefinitionsRepository;
import cucumber.eclipse.editor.steps.StepDefinitionsStorage;
import cucumber.eclipse.steps.integration.StepDefinition;
import java.util.Set;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;

public class StepHyperlinkDetector
implements IHyperlinkDetector {
    private Editor editor;

    public StepHyperlinkDetector(Editor editor) {
        this.editor = editor;
    }

    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        if (region == null || textViewer == null) {
            return null;
        }
        IDocument document = textViewer.getDocument();
        if (document == null) {
            return null;
        }
        IFile gherkinFile = this.editor.getFile();
        int offset = region.getOffset();
        try {
            int selectionLineNumber = document.getLineOfOffset(offset) + 1;
            IMarker stepDefinitionMatchMarker = JumpToStepDefinition.findStepDefinitionMatchMarker(selectionLineNumber, gherkinFile);
            if (stepDefinitionMatchMarker != null) {
                IRegion lineInfo = document.getLineInformationOfOffset(offset);
                int lineStartOffset = lineInfo.getOffset();
                String currentLine = document.get(lineStartOffset, lineInfo.getLength());
                String stepDefinitionPath = (String)stepDefinitionMatchMarker.getAttribute("cucumber.eclipse.marker.stepdef.matches.path");
                String stepDefinitionJDTHandleIdentifier = (String)stepDefinitionMatchMarker.getAttribute("cucumber.eclipse.marker.stepdef.matches.jdt_handler_identifier");
                String stepDefinitionText = (String)stepDefinitionMatchMarker.getAttribute("cucumber.eclipse.marker.stepdef.matches.text");
                Integer stepDefinitionLineNumber = (Integer)stepDefinitionMatchMarker.getAttribute("cucumber.eclipse.marker.stepdef.matches.line_number");
                String id = (String)stepDefinitionMatchMarker.getAttribute("cucumber.eclipse.marker.stepdef.matches.jdt_handler_identifier");
                if (id != null) {
                    StepDefinitionsRepository repository = StepDefinitionsStorage.INSTANCE.getOrCreate(gherkinFile.getProject(), null);
                    Set<StepDefinition> stepDefinitions = repository.getAllStepDefinitions();
                    for (StepDefinition stepDefinition : stepDefinitions) {
                        if (!id.equals(stepDefinition.getId())) continue;
                        String textStatement = (String)stepDefinitionMatchMarker.getAttribute("cucumber.eclipse.marker.stepdef.matches.text");
                        int statementStartOffset = lineStartOffset + currentLine.indexOf(textStatement);
                        Region stepRegion = new Region(statementStartOffset, textStatement.length());
                        return new IHyperlink[]{new StepHyperlink((IRegion)stepRegion, stepDefinition)};
                    }
                }
            }
        }
        catch (BadLocationException e1) {
            e1.printStackTrace();
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        return null;
    }
}

