/*
 * Decompiled with CFR 0.152.
 */
package cucumber.eclipse.launching;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.variables.VariablesPlugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate2;
import org.eclipse.jdt.launching.AbstractJavaLaunchConfigurationDelegate;
import org.eclipse.jdt.launching.IVMInstall;
import org.eclipse.jdt.launching.IVMRunner;
import org.eclipse.jdt.launching.VMRunnerConfiguration;

public class CucumberFeatureLocalApplicationLaunchConfigurationDelegate
extends AbstractJavaLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate2 {
    public void launch(ILaunchConfiguration config, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IVMInstall vm = this.verifyVMInstall(config);
        IVMRunner runner = vm.getVMRunner(mode);
        String[] classpath = this.getClasspath(config);
        VMRunnerConfiguration runConfig = new VMRunnerConfiguration("cucumber.api.cli.Main", classpath);
        this.verifyWorkingDirectory(config);
        String[] bootpath = this.getBootpath(config);
        runConfig.setBootClassPath(bootpath);
        runConfig.setVMArguments(DebugPlugin.parseArguments((String)this.getVMArguments(config)));
        runConfig.setWorkingDirectory(this.getWorkingDirectory(config).getAbsolutePath());
        String featurePath = "";
        String gluePath = "";
        boolean isMonochrome = false;
        boolean isPretty = false;
        boolean isProgress = false;
        boolean isJunit = false;
        boolean isJson = false;
        boolean isHtml = false;
        boolean isRerun = false;
        boolean isUsage = false;
        featurePath = CucumberFeatureLocalApplicationLaunchConfigurationDelegate.substituteVar(config.getAttribute("cucumber feature", featurePath));
        gluePath = config.getAttribute("glue path", gluePath);
        isMonochrome = config.getAttribute("is monochrome?", isMonochrome);
        isPretty = config.getAttribute("is pretty formatter?", isPretty);
        isProgress = config.getAttribute("is progress formatter?", isProgress);
        isJunit = config.getAttribute("is junit formatter", isJunit);
        isJson = config.getAttribute("is json formatter?", isJson);
        isHtml = config.getAttribute("is html formatter?", isHtml);
        isRerun = config.getAttribute("is rerun formatter", isRerun);
        isUsage = config.getAttribute("is usage formatter", isUsage);
        String glue = "--glue";
        String formatter = "--plugin";
        ArrayList<String> args = new ArrayList<String>();
        args.add(featurePath);
        args.add(glue);
        args.add(gluePath);
        if (isPretty) {
            args.add(formatter);
            args.add("pretty");
        }
        if (isJson) {
            args.add(formatter);
            args.add("json");
        }
        if (isJunit) {
            args.add(formatter);
            args.add("junit:STDOUT");
        }
        if (isProgress) {
            args.add(formatter);
            args.add("progress");
        }
        if (isRerun) {
            args.add(formatter);
            args.add("rerun");
        }
        if (isHtml) {
            args.add(formatter);
            args.add("html:target");
        }
        if (isUsage) {
            args.add(formatter);
            args.add("usage");
        }
        if (isMonochrome) {
            args.add("--monochrome");
        }
        args.addAll(Arrays.asList(DebugPlugin.parseArguments((String)this.getProgramArguments(config))));
        runConfig.setProgramArguments(args.toArray(new String[0]));
        runner.run(runConfig, launch, monitor);
    }

    private static String substituteVar(String s) {
        if (s == null) {
            return s;
        }
        try {
            return VariablesPlugin.getDefault().getStringVariableManager().performStringSubstitution(s);
        }
        catch (CoreException e) {
            return null;
        }
    }
}

