/*
 * Decompiled with CFR 0.152.
 */
package org.openqa.selenium.remote;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openqa.selenium.federatedcredentialmanagement.FederatedCredentialManagementAccount;
import org.openqa.selenium.federatedcredentialmanagement.FederatedCredentialManagementDialog;
import org.openqa.selenium.remote.ExecuteMethod;

class FedCmDialogImpl
implements FederatedCredentialManagementDialog {
    private final ExecuteMethod executeMethod;

    FedCmDialogImpl(ExecuteMethod executeMethod) {
        this.executeMethod = executeMethod;
    }

    public void cancelDialog() {
        this.executeMethod.execute("cancelDialog", null);
    }

    public void selectAccount(int index) {
        this.executeMethod.execute("selectAccount", Map.of("accountIndex", index));
    }

    public String getDialogType() {
        return (String)this.executeMethod.execute("getFedCmDialogType", null);
    }

    public void clickDialog() {
        this.executeMethod.execute("clickDialog", Map.of("dialogButton", "ConfirmIdpLoginContinue"));
    }

    public String getTitle() {
        Map result = (Map)this.executeMethod.execute("getFedCmTitle", null);
        return result.getOrDefault("title", null);
    }

    public String getSubtitle() {
        Map result = (Map)this.executeMethod.execute("getFedCmTitle", null);
        return result.getOrDefault("subtitle", null);
    }

    public List<FederatedCredentialManagementAccount> getAccounts() {
        List list = (List)this.executeMethod.execute("getAccounts", null);
        ArrayList<FederatedCredentialManagementAccount> accounts = new ArrayList<FederatedCredentialManagementAccount>();
        for (Map map : list) {
            accounts.add(new FederatedCredentialManagementAccount(map));
        }
        return accounts;
    }
}

