/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.execution.constants.ExecutionMessageConstants;
import com.kms.katalon.execution.exception.InvalidConsoleArgumentException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;

public class FileReader {
    public static void readArgumentFromFile(ConsoleLauncherEntity entity) throws IOException, InvalidConsoleArgumentException {
        if (entity.getOptions().has("propertiesFile")) {
            FileReader.readPropertiesFileAndSetToConsoleOptionValueMap(String.valueOf(entity.getOptions().valueOf("propertiesFile")), entity.getConsoleOptionValueMap());
            List<String> args = FileReader.buildArgumentsForPropertiesFile(entity.getArguments(), entity.getConsoleOptionValueMap());
            if (args != null) {
                entity.setAddedArguments(args);
            }
        }
    }

    private static List<String> buildArgumentsForPropertiesFile(String[] arguments, Map<String, String> consoleOptionValueMap) {
        ArrayList<String> addedArguments = new ArrayList<String>(Arrays.asList(arguments));
        consoleOptionValueMap.forEach((key, value) -> {
            boolean found = addedArguments.stream().anyMatch(arg -> arg.contains((CharSequence)key));
            if (!found) {
                addedArguments.add("-" + key + "=" + value);
            }
        });
        return addedArguments;
    }

    public static void readPropertiesFileAndSetToConsoleOptionValueMap(String fileLocation, Map<String, String> consoleOptionValueMap) throws IOException, InvalidConsoleArgumentException {
        if (!FileReader.validateFileLocation(fileLocation)) {
            throw new InvalidConsoleArgumentException(MessageFormat.format(ExecutionMessageConstants.MNG_PRT_INVALID_PROPERTY_FILE_ARG, fileLocation));
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream input = new FileInputStream(fileLocation);){
            Properties prop = new Properties();
            prop.load(input);
            for (Map.Entry<Object, Object> propertyEntry : prop.entrySet()) {
                consoleOptionValueMap.put(String.valueOf(propertyEntry.getKey()), String.valueOf(propertyEntry.getValue()));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    public static String readPropertyFileAndGetProperty(String fileLocation, String propertyName) throws IOException {
        if (!FileReader.validateFileLocation(fileLocation)) {
            return null;
        }
        Throwable throwable = null;
        Object var3_4 = null;
        try (FileInputStream input = new FileInputStream(fileLocation);){
            Properties prop = new Properties();
            prop.load(input);
            return prop.getProperty(propertyName);
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static boolean validateFileLocation(String fileLocation) {
        return StringUtils.isNotBlank((CharSequence)fileLocation) && new File(fileLocation).exists();
    }
}

