/*
 * Decompiled with CFR 0.152.
 */
package com.kms.katalon.console.handlers;

import com.katalon.platform.internal.api.PluginInstaller;
import com.kms.katalon.application.constants.ApplicationMessageConstants;
import com.kms.katalon.console.entity.ConsoleLauncherEntity;
import com.kms.katalon.execution.console.LauncherOptionParserFactory;
import com.kms.katalon.execution.util.ApiKey;
import java.io.File;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashMap;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.ServiceReference;

public class PluginHandler {
    private static void reloadPlugins(String apiKey, IEclipseContext context) throws Exception {
        Bundle katalonBundle = Platform.getBundle((String)"com.kms.katalon.activation");
        Class reloadPluginsHandlerClass = katalonBundle.loadClass("com.kms.katalon.activation.plugin.handler.ConsoleModeReloadPluginsHandler");
        Object handler = reloadPluginsHandlerClass.newInstance();
        ContextInjectionFactory.inject(handler, (IEclipseContext)context);
        Method reloadMethod = Arrays.asList(reloadPluginsHandlerClass.getMethods()).stream().filter(method -> method.getName().equals("reload")).findAny().orElse(null);
        if (reloadMethod != null) {
            reloadMethod.invoke(handler, apiKey);
        }
    }

    private static void installPlugin(String filePath) throws InterruptedException, BundleException {
        BundleContext context = Platform.getBundle((String)"com.katalon.platform").getBundleContext();
        ServiceReference serviceReference = context.getServiceReference(PluginInstaller.class);
        PluginInstaller pluginInstaller = (PluginInstaller)context.getService(serviceReference);
        if (!filePath.equals("")) {
            pluginInstaller.installPlugin(context, new File(filePath).toURI().toString());
        }
    }

    public static void loadPluginsToConsole(ConsoleLauncherEntity consoleLauncherEntity, IEclipseContext context) throws Exception {
        PluginHandler.reloadPlugins(ApiKey.get(), context);
        consoleLauncherEntity.getConsoleExecutor().addAndPrioritizeLauncherOptionParser(LauncherOptionParserFactory.getInstance().getBuilders().stream().map(a -> a.getPluginLauncherOptionParser()).collect(Collectors.toList()));
        consoleLauncherEntity.acceptConsoleOptionList(consoleLauncherEntity.getConsoleExecutor().getAllConsoleOptions());
        if (consoleLauncherEntity.getOptions().has("installPlugin")) {
            PluginHandler.installPlugin(String.valueOf(consoleLauncherEntity.getOptions().valueOf("installPlugin")));
            consoleLauncherEntity.getConsoleExecutor().addAndPrioritizeLauncherOptionParser(LauncherOptionParserFactory.getInstance().getBuilders().stream().map(a -> a.getPluginLauncherOptionParser()).collect(Collectors.toList()));
            consoleLauncherEntity.acceptConsoleOptionList(consoleLauncherEntity.getConsoleExecutor().getAllConsoleOptions());
        }
        consoleLauncherEntity.updateOptions();
    }

    public static void checkPluginLicense(String apiKey, Long orgId) {
        HashMap<String, String> localStore = new HashMap<String, String>();
        localStore.put("apiKey", apiKey);
        localStore.put("lastActivateErrorMessage", ApplicationMessageConstants.LICENSE_INVALID);
    }
}

